package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPublicAccessBlockResponse(
    publicAccessBlockConfiguration: Option[
      zio.aws.s3.model.PublicAccessBlockConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse = {
    import GetPublicAccessBlockResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
      .builder()
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly =
    zio.aws.s3.model.GetPublicAccessBlockResponse.wrap(buildAwsValue())
}
object GetPublicAccessBlockResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.GetPublicAccessBlockResponse =
      zio.aws.s3.model.GetPublicAccessBlockResponse(
        publicAccessBlockConfiguration.map(value => value.asEditable)
      )
    def publicAccessBlockConfiguration
        : Option[zio.aws.s3.model.PublicAccessBlockConfiguration.ReadOnly]
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ) extends zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly {
    override val publicAccessBlockConfiguration
        : Option[zio.aws.s3.model.PublicAccessBlockConfiguration.ReadOnly] =
      scala
        .Option(impl.publicAccessBlockConfiguration())
        .map(value =>
          zio.aws.s3.model.PublicAccessBlockConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse
  ): zio.aws.s3.model.GetPublicAccessBlockResponse.ReadOnly = new Wrapper(impl)
}
