package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Grant(
    grantee: Option[zio.aws.s3.model.Grantee] = None,
    permission: Option[zio.aws.s3.model.Permission] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Grant
      .builder()
      .optionallyWith(grantee.map(value => value.buildAwsValue()))(_.grantee)
      .optionallyWith(permission.map(value => value.unwrap))(_.permission)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Grant.ReadOnly =
    zio.aws.s3.model.Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Grant] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Grant = zio.aws.s3.model.Grant(
      grantee.map(value => value.asEditable),
      permission.map(value => value)
    )
    def grantee: Option[zio.aws.s3.model.Grantee.ReadOnly]
    def permission: Option[zio.aws.s3.model.Permission]
    def getGrantee: ZIO[Any, AwsError, zio.aws.s3.model.Grantee.ReadOnly] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getPermission: ZIO[Any, AwsError, zio.aws.s3.model.Permission] =
      AwsError.unwrapOptionField("permission", permission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Grant
  ) extends zio.aws.s3.model.Grant.ReadOnly {
    override val grantee: Option[zio.aws.s3.model.Grantee.ReadOnly] = scala
      .Option(impl.grantee())
      .map(value => zio.aws.s3.model.Grantee.wrap(value))
    override val permission: Option[zio.aws.s3.model.Permission] = scala
      .Option(impl.permission())
      .map(value => zio.aws.s3.model.Permission.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Grant
  ): zio.aws.s3.model.Grant.ReadOnly = new Wrapper(impl)
}
