package zio.aws.s3.model
import zio.aws.s3.model.primitives.Suffix
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IndexDocument(suffix: Suffix) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.IndexDocument = {
    import IndexDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.IndexDocument
      .builder()
      .suffix(Suffix.unwrap(suffix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.IndexDocument.ReadOnly =
    zio.aws.s3.model.IndexDocument.wrap(buildAwsValue())
}
object IndexDocument {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.IndexDocument] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.IndexDocument =
      zio.aws.s3.model.IndexDocument(suffix)
    def suffix: Suffix
    def getSuffix: ZIO[Any, Nothing, Suffix] = ZIO.succeed(suffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.IndexDocument
  ) extends zio.aws.s3.model.IndexDocument.ReadOnly {
    override val suffix: Suffix =
      zio.aws.s3.model.primitives.Suffix(impl.suffix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.IndexDocument
  ): zio.aws.s3.model.IndexDocument.ReadOnly = new Wrapper(impl)
}
