package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputSerialization(
    csv: Option[zio.aws.s3.model.CSVInput] = None,
    compressionType: Option[zio.aws.s3.model.CompressionType] = None,
    json: Option[zio.aws.s3.model.JSONInput] = None,
    parquet: Option[zio.aws.s3.model.ParquetInput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InputSerialization = {
    import InputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .optionallyWith(parquet.map(value => value.buildAwsValue()))(_.parquet)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InputSerialization.ReadOnly =
    zio.aws.s3.model.InputSerialization.wrap(buildAwsValue())
}
object InputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InputSerialization =
      zio.aws.s3.model.InputSerialization(
        csv.map(value => value.asEditable),
        compressionType.map(value => value),
        json.map(value => value.asEditable),
        parquet.map(value => value.asEditable)
      )
    def csv: Option[zio.aws.s3.model.CSVInput.ReadOnly]
    def compressionType: Option[zio.aws.s3.model.CompressionType]
    def json: Option[zio.aws.s3.model.JSONInput.ReadOnly]
    def parquet: Option[zio.aws.s3.model.ParquetInput.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.s3.model.CSVInput.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.s3.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getJson: ZIO[Any, AwsError, zio.aws.s3.model.JSONInput.ReadOnly] =
      AwsError.unwrapOptionField("json", json)
    def getParquet: ZIO[Any, AwsError, zio.aws.s3.model.ParquetInput.ReadOnly] =
      AwsError.unwrapOptionField("parquet", parquet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ) extends zio.aws.s3.model.InputSerialization.ReadOnly {
    override val csv: Option[zio.aws.s3.model.CSVInput.ReadOnly] = scala
      .Option(impl.csv())
      .map(value => zio.aws.s3.model.CSVInput.wrap(value))
    override val compressionType: Option[zio.aws.s3.model.CompressionType] =
      scala
        .Option(impl.compressionType())
        .map(value => zio.aws.s3.model.CompressionType.wrap(value))
    override val json: Option[zio.aws.s3.model.JSONInput.ReadOnly] = scala
      .Option(impl.json())
      .map(value => zio.aws.s3.model.JSONInput.wrap(value))
    override val parquet: Option[zio.aws.s3.model.ParquetInput.ReadOnly] = scala
      .Option(impl.parquet())
      .map(value => zio.aws.s3.model.ParquetInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InputSerialization
  ): zio.aws.s3.model.InputSerialization.ReadOnly = new Wrapper(impl)
}
