package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait IntelligentTieringStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.IntelligentTieringStatus
}
object IntelligentTieringStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.IntelligentTieringStatus
  ): zio.aws.s3.model.IntelligentTieringStatus = value match {
    case software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.IntelligentTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringStatus =
      software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3.model.IntelligentTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringStatus =
      software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3.model.IntelligentTieringStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.IntelligentTieringStatus =
      software.amazon.awssdk.services.s3.model.IntelligentTieringStatus.DISABLED
  }
}
