package zio.aws.s3.model
import zio.aws.s3.model.primitives.{InventoryId, IsEnabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InventoryConfiguration(
    destination: zio.aws.s3.model.InventoryDestination,
    isEnabled: IsEnabled,
    filter: Option[zio.aws.s3.model.InventoryFilter] = None,
    id: InventoryId,
    includedObjectVersions: zio.aws.s3.model.InventoryIncludedObjectVersions,
    optionalFields: Option[Iterable[zio.aws.s3.model.InventoryOptionalField]] =
      None,
    schedule: zio.aws.s3.model.InventorySchedule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.InventoryConfiguration = {
    import InventoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.InventoryConfiguration
      .builder()
      .destination(destination.buildAwsValue())
      .isEnabled(IsEnabled.unwrap(isEnabled): java.lang.Boolean)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .id(InventoryId.unwrap(id): java.lang.String)
      .includedObjectVersions(includedObjectVersions.unwrap)
      .optionallyWith(
        optionalFields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionalFieldsWithStrings)
      .schedule(schedule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.InventoryConfiguration.ReadOnly =
    zio.aws.s3.model.InventoryConfiguration.wrap(buildAwsValue())
}
object InventoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.InventoryConfiguration =
      zio.aws.s3.model.InventoryConfiguration(
        destination.asEditable,
        isEnabled,
        filter.map(value => value.asEditable),
        id,
        includedObjectVersions,
        optionalFields.map(value => value),
        schedule.asEditable
      )
    def destination: zio.aws.s3.model.InventoryDestination.ReadOnly
    def isEnabled: IsEnabled
    def filter: Option[zio.aws.s3.model.InventoryFilter.ReadOnly]
    def id: InventoryId
    def includedObjectVersions: zio.aws.s3.model.InventoryIncludedObjectVersions
    def optionalFields: Option[List[zio.aws.s3.model.InventoryOptionalField]]
    def schedule: zio.aws.s3.model.InventorySchedule.ReadOnly
    def getDestination
        : ZIO[Any, Nothing, zio.aws.s3.model.InventoryDestination.ReadOnly] =
      ZIO.succeed(destination)
    def getIsEnabled: ZIO[Any, Nothing, IsEnabled] = ZIO.succeed(isEnabled)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.s3.model.InventoryFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getId: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(id)
    def getIncludedObjectVersions
        : ZIO[Any, Nothing, zio.aws.s3.model.InventoryIncludedObjectVersions] =
      ZIO.succeed(includedObjectVersions)
    def getOptionalFields
        : ZIO[Any, AwsError, List[zio.aws.s3.model.InventoryOptionalField]] =
      AwsError.unwrapOptionField("optionalFields", optionalFields)
    def getSchedule
        : ZIO[Any, Nothing, zio.aws.s3.model.InventorySchedule.ReadOnly] =
      ZIO.succeed(schedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ) extends zio.aws.s3.model.InventoryConfiguration.ReadOnly {
    override val destination: zio.aws.s3.model.InventoryDestination.ReadOnly =
      zio.aws.s3.model.InventoryDestination.wrap(impl.destination())
    override val isEnabled: IsEnabled =
      zio.aws.s3.model.primitives.IsEnabled(impl.isEnabled())
    override val filter: Option[zio.aws.s3.model.InventoryFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.s3.model.InventoryFilter.wrap(value))
    override val id: InventoryId =
      zio.aws.s3.model.primitives.InventoryId(impl.id())
    override val includedObjectVersions
        : zio.aws.s3.model.InventoryIncludedObjectVersions =
      zio.aws.s3.model.InventoryIncludedObjectVersions
        .wrap(impl.includedObjectVersions())
    override val optionalFields
        : Option[List[zio.aws.s3.model.InventoryOptionalField]] = scala
      .Option(impl.optionalFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.InventoryOptionalField.wrap(item)
        }.toList
      )
    override val schedule: zio.aws.s3.model.InventorySchedule.ReadOnly =
      zio.aws.s3.model.InventorySchedule.wrap(impl.schedule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.InventoryConfiguration
  ): zio.aws.s3.model.InventoryConfiguration.ReadOnly = new Wrapper(impl)
}
