package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait InventoryOptionalField {
  def unwrap: software.amazon.awssdk.services.s3.model.InventoryOptionalField
}
object InventoryOptionalField {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.InventoryOptionalField
  ): zio.aws.s3.model.InventoryOptionalField = value match {
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.SIZE =>
      val r = Size
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.LAST_MODIFIED_DATE =>
      val r = LastModifiedDate
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.STORAGE_CLASS =>
      val r = StorageClass
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.E_TAG =>
      val r = ETag
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.IS_MULTIPART_UPLOADED =>
      val r = IsMultipartUploaded
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.REPLICATION_STATUS =>
      val r = ReplicationStatus
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.ENCRYPTION_STATUS =>
      val r = EncryptionStatus
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_RETAIN_UNTIL_DATE =>
      val r = ObjectLockRetainUntilDate
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_MODE =>
      val r = ObjectLockMode
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_LEGAL_HOLD_STATUS =>
      val r = ObjectLockLegalHoldStatus
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.INTELLIGENT_TIERING_ACCESS_TIER =>
      val r = IntelligentTieringAccessTier
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.BUCKET_KEY_STATUS =>
      val r = BucketKeyStatus
      r
    case software.amazon.awssdk.services.s3.model.InventoryOptionalField.CHECKSUM_ALGORITHM =>
      val r = ChecksumAlgorithm
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.UNKNOWN_TO_SDK_VERSION
  }
  case object Size extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.SIZE
  }
  case object LastModifiedDate extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.LAST_MODIFIED_DATE
  }
  case object StorageClass extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.STORAGE_CLASS
  }
  case object ETag extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.E_TAG
  }
  case object IsMultipartUploaded
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.IS_MULTIPART_UPLOADED
  }
  case object ReplicationStatus
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.REPLICATION_STATUS
  }
  case object EncryptionStatus extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.ENCRYPTION_STATUS
  }
  case object ObjectLockRetainUntilDate
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_RETAIN_UNTIL_DATE
  }
  case object ObjectLockMode extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_MODE
  }
  case object ObjectLockLegalHoldStatus
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.OBJECT_LOCK_LEGAL_HOLD_STATUS
  }
  case object IntelligentTieringAccessTier
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.INTELLIGENT_TIERING_ACCESS_TIER
  }
  case object BucketKeyStatus extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.BUCKET_KEY_STATUS
  }
  case object ChecksumAlgorithm
      extends zio.aws.s3.model.InventoryOptionalField {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.InventoryOptionalField =
      software.amazon.awssdk.services.s3.model.InventoryOptionalField.CHECKSUM_ALGORITHM
  }
}
