package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait JSONType {
  def unwrap: software.amazon.awssdk.services.s3.model.JSONType
}
object JSONType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.JSONType
  ): zio.aws.s3.model.JSONType = value match {
    case software.amazon.awssdk.services.s3.model.JSONType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.JSONType.DOCUMENT =>
      val r = DOCUMENT
      r
    case software.amazon.awssdk.services.s3.model.JSONType.LINES =>
      val r = LINES
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT extends zio.aws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.DOCUMENT
  }
  case object LINES extends zio.aws.s3.model.JSONType {
    override def unwrap: software.amazon.awssdk.services.s3.model.JSONType =
      software.amazon.awssdk.services.s3.model.JSONType.LINES
  }
}
