package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{ExpiredObjectDeleteMarker, Days, Date}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LifecycleExpiration(
    date: Option[Date] = None,
    days: Option[Days] = None,
    expiredObjectDeleteMarker: Option[ExpiredObjectDeleteMarker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleExpiration = {
    import LifecycleExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleExpiration
      .builder()
      .optionallyWith(date.map(value => Date.unwrap(value): Instant))(_.date)
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(
        expiredObjectDeleteMarker.map(value =>
          ExpiredObjectDeleteMarker.unwrap(value): java.lang.Boolean
        )
      )(_.expiredObjectDeleteMarker)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleExpiration.ReadOnly =
    zio.aws.s3.model.LifecycleExpiration.wrap(buildAwsValue())
}
object LifecycleExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleExpiration =
      zio.aws.s3.model.LifecycleExpiration(
        date.map(value => value),
        days.map(value => value),
        expiredObjectDeleteMarker.map(value => value)
      )
    def date: Option[Date]
    def days: Option[Days]
    def expiredObjectDeleteMarker: Option[ExpiredObjectDeleteMarker]
    def getDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("date", date)
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getExpiredObjectDeleteMarker
        : ZIO[Any, AwsError, ExpiredObjectDeleteMarker] = AwsError
      .unwrapOptionField("expiredObjectDeleteMarker", expiredObjectDeleteMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ) extends zio.aws.s3.model.LifecycleExpiration.ReadOnly {
    override val date: Option[Date] = scala
      .Option(impl.date())
      .map(value => zio.aws.s3.model.primitives.Date(value))
    override val days: Option[Days] = scala
      .Option(impl.days())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val expiredObjectDeleteMarker: Option[ExpiredObjectDeleteMarker] =
      scala
        .Option(impl.expiredObjectDeleteMarker())
        .map(value =>
          zio.aws.s3.model.primitives.ExpiredObjectDeleteMarker(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleExpiration
  ): zio.aws.s3.model.LifecycleExpiration.ReadOnly = new Wrapper(impl)
}
