package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Prefix, ID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LifecycleRule(
    expiration: Option[zio.aws.s3.model.LifecycleExpiration] = None,
    id: Option[ID] = None,
    prefix: Option[Prefix] = None,
    filter: Option[zio.aws.s3.model.LifecycleRuleFilter] = None,
    status: zio.aws.s3.model.ExpirationStatus,
    transitions: Option[Iterable[zio.aws.s3.model.Transition]] = None,
    noncurrentVersionTransitions: Option[
      Iterable[zio.aws.s3.model.NoncurrentVersionTransition]
    ] = None,
    noncurrentVersionExpiration: Option[
      zio.aws.s3.model.NoncurrentVersionExpiration
    ] = None,
    abortIncompleteMultipartUpload: Option[
      zio.aws.s3.model.AbortIncompleteMultipartUpload
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRule = {
    import LifecycleRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRule
      .builder()
      .optionallyWith(expiration.map(value => value.buildAwsValue()))(
        _.expiration
      )
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .status(status.unwrap)
      .optionallyWith(
        transitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitions)
      .optionallyWith(
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noncurrentVersionTransitions)
      .optionallyWith(
        noncurrentVersionExpiration.map(value => value.buildAwsValue())
      )(_.noncurrentVersionExpiration)
      .optionallyWith(
        abortIncompleteMultipartUpload.map(value => value.buildAwsValue())
      )(_.abortIncompleteMultipartUpload)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleRule.ReadOnly =
    zio.aws.s3.model.LifecycleRule.wrap(buildAwsValue())
}
object LifecycleRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.LifecycleRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleRule =
      zio.aws.s3.model.LifecycleRule(
        expiration.map(value => value.asEditable),
        id.map(value => value),
        prefix.map(value => value),
        filter.map(value => value.asEditable),
        status,
        transitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionTransitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noncurrentVersionExpiration.map(value => value.asEditable),
        abortIncompleteMultipartUpload.map(value => value.asEditable)
      )
    def expiration: Option[zio.aws.s3.model.LifecycleExpiration.ReadOnly]
    def id: Option[ID]
    def prefix: Option[Prefix]
    def filter: Option[zio.aws.s3.model.LifecycleRuleFilter.ReadOnly]
    def status: zio.aws.s3.model.ExpirationStatus
    def transitions: Option[List[zio.aws.s3.model.Transition.ReadOnly]]
    def noncurrentVersionTransitions
        : Option[List[zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly]]
    def noncurrentVersionExpiration
        : Option[zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly]
    def abortIncompleteMultipartUpload
        : Option[zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly]
    def getExpiration
        : ZIO[Any, AwsError, zio.aws.s3.model.LifecycleExpiration.ReadOnly] =
      AwsError.unwrapOptionField("expiration", expiration)
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.s3.model.LifecycleRuleFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getStatus: ZIO[Any, Nothing, zio.aws.s3.model.ExpirationStatus] =
      ZIO.succeed(status)
    def getTransitions
        : ZIO[Any, AwsError, List[zio.aws.s3.model.Transition.ReadOnly]] =
      AwsError.unwrapOptionField("transitions", transitions)
    def getNoncurrentVersionTransitions: ZIO[Any, AwsError, List[
      zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "noncurrentVersionTransitions",
      noncurrentVersionTransitions
    )
    def getNoncurrentVersionExpiration: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "noncurrentVersionExpiration",
      noncurrentVersionExpiration
    )
    def getAbortIncompleteMultipartUpload: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "abortIncompleteMultipartUpload",
      abortIncompleteMultipartUpload
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ) extends zio.aws.s3.model.LifecycleRule.ReadOnly {
    override val expiration
        : Option[zio.aws.s3.model.LifecycleExpiration.ReadOnly] = scala
      .Option(impl.expiration())
      .map(value => zio.aws.s3.model.LifecycleExpiration.wrap(value))
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.s3.model.primitives.ID(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val filter: Option[zio.aws.s3.model.LifecycleRuleFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value => zio.aws.s3.model.LifecycleRuleFilter.wrap(value))
    override val status: zio.aws.s3.model.ExpirationStatus =
      zio.aws.s3.model.ExpirationStatus.wrap(impl.status())
    override val transitions
        : Option[List[zio.aws.s3.model.Transition.ReadOnly]] = scala
      .Option(impl.transitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.Transition.wrap(item)
        }.toList
      )
    override val noncurrentVersionTransitions
        : Option[List[zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly]] =
      scala
        .Option(impl.noncurrentVersionTransitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.NoncurrentVersionTransition.wrap(item)
          }.toList
        )
    override val noncurrentVersionExpiration
        : Option[zio.aws.s3.model.NoncurrentVersionExpiration.ReadOnly] = scala
      .Option(impl.noncurrentVersionExpiration())
      .map(value => zio.aws.s3.model.NoncurrentVersionExpiration.wrap(value))
    override val abortIncompleteMultipartUpload
        : Option[zio.aws.s3.model.AbortIncompleteMultipartUpload.ReadOnly] =
      scala
        .Option(impl.abortIncompleteMultipartUpload())
        .map(value =>
          zio.aws.s3.model.AbortIncompleteMultipartUpload.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRule
  ): zio.aws.s3.model.LifecycleRule.ReadOnly = new Wrapper(impl)
}
