package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ObjectSizeLessThanBytes,
  ObjectSizeGreaterThanBytes,
  Prefix
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LifecycleRuleAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[zio.aws.s3.model.Tag]] = None,
    objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] = None,
    objectSizeLessThan: Option[ObjectSizeLessThanBytes] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator = {
    import LifecycleRuleAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        objectSizeGreaterThan.map(value =>
          ObjectSizeGreaterThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeGreaterThan)
      .optionallyWith(
        objectSizeLessThan.map(value =>
          ObjectSizeLessThanBytes.unwrap(value): java.lang.Long
        )
      )(_.objectSizeLessThan)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly =
    zio.aws.s3.model.LifecycleRuleAndOperator.wrap(buildAwsValue())
}
object LifecycleRuleAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LifecycleRuleAndOperator =
      zio.aws.s3.model.LifecycleRuleAndOperator(
        prefix.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectSizeGreaterThan.map(value => value),
        objectSizeLessThan.map(value => value)
      )
    def prefix: Option[Prefix]
    def tags: Option[List[zio.aws.s3.model.Tag.ReadOnly]]
    def objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes]
    def objectSizeLessThan: Option[ObjectSizeLessThanBytes]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTags: ZIO[Any, AwsError, List[zio.aws.s3.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getObjectSizeGreaterThan
        : ZIO[Any, AwsError, ObjectSizeGreaterThanBytes] =
      AwsError.unwrapOptionField("objectSizeGreaterThan", objectSizeGreaterThan)
    def getObjectSizeLessThan: ZIO[Any, AwsError, ObjectSizeLessThanBytes] =
      AwsError.unwrapOptionField("objectSizeLessThan", objectSizeLessThan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ) extends zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tags: Option[List[zio.aws.s3.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.Tag.wrap(item)
        }.toList
      )
    override val objectSizeGreaterThan: Option[ObjectSizeGreaterThanBytes] =
      scala
        .Option(impl.objectSizeGreaterThan())
        .map(value =>
          zio.aws.s3.model.primitives.ObjectSizeGreaterThanBytes(value)
        )
    override val objectSizeLessThan: Option[ObjectSizeLessThanBytes] = scala
      .Option(impl.objectSizeLessThan())
      .map(value => zio.aws.s3.model.primitives.ObjectSizeLessThanBytes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator
  ): zio.aws.s3.model.LifecycleRuleAndOperator.ReadOnly = new Wrapper(impl)
}
