package zio.aws.s3.model
import zio.aws.s3.model.primitives.{NextToken, Token, IsTruncated}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBucketAnalyticsConfigurationsResponse(
    isTruncated: Option[IsTruncated] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    analyticsConfigurationList: Option[
      Iterable[zio.aws.s3.model.AnalyticsConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse = {
    import ListBucketAnalyticsConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .optionallyWith(
        analyticsConfigurationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.analyticsConfigurationList)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly =
    zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListBucketAnalyticsConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse =
      zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse(
        isTruncated.map(value => value),
        continuationToken.map(value => value),
        nextContinuationToken.map(value => value),
        analyticsConfigurationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def isTruncated: Option[IsTruncated]
    def continuationToken: Option[Token]
    def nextContinuationToken: Option[NextToken]
    def analyticsConfigurationList
        : Option[List[zio.aws.s3.model.AnalyticsConfiguration.ReadOnly]]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
    def getAnalyticsConfigurationList: ZIO[Any, AwsError, List[
      zio.aws.s3.model.AnalyticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "analyticsConfigurationList",
      analyticsConfigurationList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ) extends zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly {
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val nextContinuationToken: Option[NextToken] = scala
      .Option(impl.nextContinuationToken())
      .map(value => zio.aws.s3.model.primitives.NextToken(value))
    override val analyticsConfigurationList
        : Option[List[zio.aws.s3.model.AnalyticsConfiguration.ReadOnly]] = scala
      .Option(impl.analyticsConfigurationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.AnalyticsConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse
  ): zio.aws.s3.model.ListBucketAnalyticsConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
