package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  Prefix,
  AccountId,
  MaxUploads,
  Delimiter,
  BucketName,
  KeyMarker,
  UploadIdMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMultipartUploadsRequest(
    bucket: BucketName,
    delimiter: Option[Delimiter] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None,
    keyMarker: Option[KeyMarker] = None,
    maxUploads: Option[MaxUploads] = None,
    prefix: Option[Prefix] = None,
    uploadIdMarker: Option[UploadIdMarker] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest = {
    import ListMultipartUploadsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(
        maxUploads.map(value => MaxUploads.unwrap(value): Integer)
      )(_.maxUploads)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        uploadIdMarker.map(value =>
          UploadIdMarker.unwrap(value): java.lang.String
        )
      )(_.uploadIdMarker)
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListMultipartUploadsRequest.ReadOnly =
    zio.aws.s3.model.ListMultipartUploadsRequest.wrap(buildAwsValue())
}
object ListMultipartUploadsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListMultipartUploadsRequest =
      zio.aws.s3.model.ListMultipartUploadsRequest(
        bucket,
        delimiter.map(value => value),
        encodingType.map(value => value),
        keyMarker.map(value => value),
        maxUploads.map(value => value),
        prefix.map(value => value),
        uploadIdMarker.map(value => value),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def delimiter: Option[Delimiter]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def keyMarker: Option[KeyMarker]
    def maxUploads: Option[MaxUploads]
    def prefix: Option[Prefix]
    def uploadIdMarker: Option[UploadIdMarker]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getMaxUploads: ZIO[Any, AwsError, MaxUploads] =
      AwsError.unwrapOptionField("maxUploads", maxUploads)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getUploadIdMarker: ZIO[Any, AwsError, UploadIdMarker] =
      AwsError.unwrapOptionField("uploadIdMarker", uploadIdMarker)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ) extends zio.aws.s3.model.ListMultipartUploadsRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val keyMarker: Option[KeyMarker] = scala
      .Option(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val maxUploads: Option[MaxUploads] = scala
      .Option(impl.maxUploads())
      .map(value => zio.aws.s3.model.primitives.MaxUploads(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val uploadIdMarker: Option[UploadIdMarker] = scala
      .Option(impl.uploadIdMarker())
      .map(value => zio.aws.s3.model.primitives.UploadIdMarker(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest
  ): zio.aws.s3.model.ListMultipartUploadsRequest.ReadOnly = new Wrapper(impl)
}
