package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  Prefix,
  MaxUploads,
  Delimiter,
  BucketName,
  KeyMarker,
  IsTruncated,
  NextKeyMarker,
  NextUploadIdMarker,
  UploadIdMarker
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMultipartUploadsResponse(
    bucket: Option[BucketName] = None,
    keyMarker: Option[KeyMarker] = None,
    uploadIdMarker: Option[UploadIdMarker] = None,
    nextKeyMarker: Option[NextKeyMarker] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    nextUploadIdMarker: Option[NextUploadIdMarker] = None,
    maxUploads: Option[MaxUploads] = None,
    isTruncated: Option[IsTruncated] = None,
    uploads: Option[Iterable[zio.aws.s3.model.MultipartUpload]] = None,
    commonPrefixes: Option[Iterable[zio.aws.s3.model.CommonPrefix]] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse = {
    import ListMultipartUploadsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
      .builder()
      .optionallyWith(
        bucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        keyMarker.map(value => KeyMarker.unwrap(value): java.lang.String)
      )(_.keyMarker)
      .optionallyWith(
        uploadIdMarker.map(value =>
          UploadIdMarker.unwrap(value): java.lang.String
        )
      )(_.uploadIdMarker)
      .optionallyWith(
        nextKeyMarker.map(value =>
          NextKeyMarker.unwrap(value): java.lang.String
        )
      )(_.nextKeyMarker)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(
        nextUploadIdMarker.map(value =>
          NextUploadIdMarker.unwrap(value): java.lang.String
        )
      )(_.nextUploadIdMarker)
      .optionallyWith(
        maxUploads.map(value => MaxUploads.unwrap(value): Integer)
      )(_.maxUploads)
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        uploads.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.uploads)
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly =
    zio.aws.s3.model.ListMultipartUploadsResponse.wrap(buildAwsValue())
}
object ListMultipartUploadsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListMultipartUploadsResponse =
      zio.aws.s3.model.ListMultipartUploadsResponse(
        bucket.map(value => value),
        keyMarker.map(value => value),
        uploadIdMarker.map(value => value),
        nextKeyMarker.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        nextUploadIdMarker.map(value => value),
        maxUploads.map(value => value),
        isTruncated.map(value => value),
        uploads.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value)
      )
    def bucket: Option[BucketName]
    def keyMarker: Option[KeyMarker]
    def uploadIdMarker: Option[UploadIdMarker]
    def nextKeyMarker: Option[NextKeyMarker]
    def prefix: Option[Prefix]
    def delimiter: Option[Delimiter]
    def nextUploadIdMarker: Option[NextUploadIdMarker]
    def maxUploads: Option[MaxUploads]
    def isTruncated: Option[IsTruncated]
    def uploads: Option[List[zio.aws.s3.model.MultipartUpload.ReadOnly]]
    def commonPrefixes: Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def getBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKeyMarker: ZIO[Any, AwsError, KeyMarker] =
      AwsError.unwrapOptionField("keyMarker", keyMarker)
    def getUploadIdMarker: ZIO[Any, AwsError, UploadIdMarker] =
      AwsError.unwrapOptionField("uploadIdMarker", uploadIdMarker)
    def getNextKeyMarker: ZIO[Any, AwsError, NextKeyMarker] =
      AwsError.unwrapOptionField("nextKeyMarker", nextKeyMarker)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getNextUploadIdMarker: ZIO[Any, AwsError, NextUploadIdMarker] =
      AwsError.unwrapOptionField("nextUploadIdMarker", nextUploadIdMarker)
    def getMaxUploads: ZIO[Any, AwsError, MaxUploads] =
      AwsError.unwrapOptionField("maxUploads", maxUploads)
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getUploads
        : ZIO[Any, AwsError, List[zio.aws.s3.model.MultipartUpload.ReadOnly]] =
      AwsError.unwrapOptionField("uploads", uploads)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ) extends zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly {
    override val bucket: Option[BucketName] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val keyMarker: Option[KeyMarker] = scala
      .Option(impl.keyMarker())
      .map(value => zio.aws.s3.model.primitives.KeyMarker(value))
    override val uploadIdMarker: Option[UploadIdMarker] = scala
      .Option(impl.uploadIdMarker())
      .map(value => zio.aws.s3.model.primitives.UploadIdMarker(value))
    override val nextKeyMarker: Option[NextKeyMarker] = scala
      .Option(impl.nextKeyMarker())
      .map(value => zio.aws.s3.model.primitives.NextKeyMarker(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val nextUploadIdMarker: Option[NextUploadIdMarker] = scala
      .Option(impl.nextUploadIdMarker())
      .map(value => zio.aws.s3.model.primitives.NextUploadIdMarker(value))
    override val maxUploads: Option[MaxUploads] = scala
      .Option(impl.maxUploads())
      .map(value => zio.aws.s3.model.primitives.MaxUploads(value))
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val uploads
        : Option[List[zio.aws.s3.model.MultipartUpload.ReadOnly]] = scala
      .Option(impl.uploads())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.MultipartUpload.wrap(item)
        }.toList
      )
    override val commonPrefixes
        : Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] = scala
      .Option(impl.commonPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.CommonPrefix.wrap(item)
        }.toList
      )
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse
  ): zio.aws.s3.model.ListMultipartUploadsResponse.ReadOnly = new Wrapper(impl)
}
