package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  Marker,
  MaxKeys,
  Prefix,
  NextMarker,
  Delimiter,
  BucketName,
  IsTruncated
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectsResponse(
    isTruncated: Option[IsTruncated] = None,
    marker: Option[Marker] = None,
    nextMarker: Option[NextMarker] = None,
    contents: Option[Iterable[zio.aws.s3.model.S3Object]] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[Iterable[zio.aws.s3.model.CommonPrefix]] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsResponse = {
    import ListObjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsResponse.ReadOnly =
    zio.aws.s3.model.ListObjectsResponse.wrap(buildAwsValue())
}
object ListObjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsResponse =
      zio.aws.s3.model.ListObjectsResponse(
        isTruncated.map(value => value),
        marker.map(value => value),
        nextMarker.map(value => value),
        contents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value)
      )
    def isTruncated: Option[IsTruncated]
    def marker: Option[Marker]
    def nextMarker: Option[NextMarker]
    def contents: Option[List[zio.aws.s3.model.S3Object.ReadOnly]]
    def name: Option[BucketName]
    def prefix: Option[Prefix]
    def delimiter: Option[Delimiter]
    def maxKeys: Option[MaxKeys]
    def commonPrefixes: Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getContents
        : ZIO[Any, AwsError, List[zio.aws.s3.model.S3Object.ReadOnly]] =
      AwsError.unwrapOptionField("contents", contents)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ) extends zio.aws.s3.model.ListObjectsResponse.ReadOnly {
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.s3.model.primitives.Marker(value))
    override val nextMarker: Option[NextMarker] = scala
      .Option(impl.nextMarker())
      .map(value => zio.aws.s3.model.primitives.NextMarker(value))
    override val contents: Option[List[zio.aws.s3.model.S3Object.ReadOnly]] =
      scala
        .Option(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override val name: Option[BucketName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Option[MaxKeys] = scala
      .Option(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] = scala
      .Option(impl.commonPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.CommonPrefix.wrap(item)
        }.toList
      )
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsResponse
  ): zio.aws.s3.model.ListObjectsResponse.ReadOnly = new Wrapper(impl)
}
