package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  MaxKeys,
  NextToken,
  Token,
  Prefix,
  StartAfter,
  Delimiter,
  BucketName,
  IsTruncated,
  KeyCount
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListObjectsV2Response(
    isTruncated: Option[IsTruncated] = None,
    contents: Option[Iterable[zio.aws.s3.model.S3Object]] = None,
    name: Option[BucketName] = None,
    prefix: Option[Prefix] = None,
    delimiter: Option[Delimiter] = None,
    maxKeys: Option[MaxKeys] = None,
    commonPrefixes: Option[Iterable[zio.aws.s3.model.CommonPrefix]] = None,
    encodingType: Option[zio.aws.s3.model.EncodingType] = None,
    keyCount: Option[KeyCount] = None,
    continuationToken: Option[Token] = None,
    nextContinuationToken: Option[NextToken] = None,
    startAfter: Option[StartAfter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ListObjectsV2Response = {
    import ListObjectsV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
      .builder()
      .optionallyWith(
        isTruncated.map(value => IsTruncated.unwrap(value): java.lang.Boolean)
      )(_.isTruncated)
      .optionallyWith(
        contents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contents)
      .optionallyWith(
        name.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        delimiter.map(value => Delimiter.unwrap(value): java.lang.String)
      )(_.delimiter)
      .optionallyWith(maxKeys.map(value => MaxKeys.unwrap(value): Integer))(
        _.maxKeys
      )
      .optionallyWith(
        commonPrefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commonPrefixes)
      .optionallyWith(encodingType.map(value => value.unwrap))(_.encodingType)
      .optionallyWith(keyCount.map(value => KeyCount.unwrap(value): Integer))(
        _.keyCount
      )
      .optionallyWith(
        continuationToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.continuationToken)
      .optionallyWith(
        nextContinuationToken.map(value =>
          NextToken.unwrap(value): java.lang.String
        )
      )(_.nextContinuationToken)
      .optionallyWith(
        startAfter.map(value => StartAfter.unwrap(value): java.lang.String)
      )(_.startAfter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ListObjectsV2Response.ReadOnly =
    zio.aws.s3.model.ListObjectsV2Response.wrap(buildAwsValue())
}
object ListObjectsV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ListObjectsV2Response =
      zio.aws.s3.model.ListObjectsV2Response(
        isTruncated.map(value => value),
        contents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        prefix.map(value => value),
        delimiter.map(value => value),
        maxKeys.map(value => value),
        commonPrefixes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encodingType.map(value => value),
        keyCount.map(value => value),
        continuationToken.map(value => value),
        nextContinuationToken.map(value => value),
        startAfter.map(value => value)
      )
    def isTruncated: Option[IsTruncated]
    def contents: Option[List[zio.aws.s3.model.S3Object.ReadOnly]]
    def name: Option[BucketName]
    def prefix: Option[Prefix]
    def delimiter: Option[Delimiter]
    def maxKeys: Option[MaxKeys]
    def commonPrefixes: Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]]
    def encodingType: Option[zio.aws.s3.model.EncodingType]
    def keyCount: Option[KeyCount]
    def continuationToken: Option[Token]
    def nextContinuationToken: Option[NextToken]
    def startAfter: Option[StartAfter]
    def getIsTruncated: ZIO[Any, AwsError, IsTruncated] =
      AwsError.unwrapOptionField("isTruncated", isTruncated)
    def getContents
        : ZIO[Any, AwsError, List[zio.aws.s3.model.S3Object.ReadOnly]] =
      AwsError.unwrapOptionField("contents", contents)
    def getName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", name)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getDelimiter: ZIO[Any, AwsError, Delimiter] =
      AwsError.unwrapOptionField("delimiter", delimiter)
    def getMaxKeys: ZIO[Any, AwsError, MaxKeys] =
      AwsError.unwrapOptionField("maxKeys", maxKeys)
    def getCommonPrefixes
        : ZIO[Any, AwsError, List[zio.aws.s3.model.CommonPrefix.ReadOnly]] =
      AwsError.unwrapOptionField("commonPrefixes", commonPrefixes)
    def getEncodingType: ZIO[Any, AwsError, zio.aws.s3.model.EncodingType] =
      AwsError.unwrapOptionField("encodingType", encodingType)
    def getKeyCount: ZIO[Any, AwsError, KeyCount] =
      AwsError.unwrapOptionField("keyCount", keyCount)
    def getContinuationToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getNextContinuationToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextContinuationToken", nextContinuationToken)
    def getStartAfter: ZIO[Any, AwsError, StartAfter] =
      AwsError.unwrapOptionField("startAfter", startAfter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ) extends zio.aws.s3.model.ListObjectsV2Response.ReadOnly {
    override val isTruncated: Option[IsTruncated] = scala
      .Option(impl.isTruncated())
      .map(value => zio.aws.s3.model.primitives.IsTruncated(value))
    override val contents: Option[List[zio.aws.s3.model.S3Object.ReadOnly]] =
      scala
        .Option(impl.contents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3.model.S3Object.wrap(item)
          }.toList
        )
    override val name: Option[BucketName] = scala
      .Option(impl.name())
      .map(value => zio.aws.s3.model.primitives.BucketName(value))
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val delimiter: Option[Delimiter] = scala
      .Option(impl.delimiter())
      .map(value => zio.aws.s3.model.primitives.Delimiter(value))
    override val maxKeys: Option[MaxKeys] = scala
      .Option(impl.maxKeys())
      .map(value => zio.aws.s3.model.primitives.MaxKeys(value))
    override val commonPrefixes
        : Option[List[zio.aws.s3.model.CommonPrefix.ReadOnly]] = scala
      .Option(impl.commonPrefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.CommonPrefix.wrap(item)
        }.toList
      )
    override val encodingType: Option[zio.aws.s3.model.EncodingType] = scala
      .Option(impl.encodingType())
      .map(value => zio.aws.s3.model.EncodingType.wrap(value))
    override val keyCount: Option[KeyCount] = scala
      .Option(impl.keyCount())
      .map(value => zio.aws.s3.model.primitives.KeyCount(value))
    override val continuationToken: Option[Token] = scala
      .Option(impl.continuationToken())
      .map(value => zio.aws.s3.model.primitives.Token(value))
    override val nextContinuationToken: Option[NextToken] = scala
      .Option(impl.nextContinuationToken())
      .map(value => zio.aws.s3.model.primitives.NextToken(value))
    override val startAfter: Option[StartAfter] = scala
      .Option(impl.startAfter())
      .map(value => zio.aws.s3.model.primitives.StartAfter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ListObjectsV2Response
  ): zio.aws.s3.model.ListObjectsV2Response.ReadOnly = new Wrapper(impl)
}
