package zio.aws.s3.model
import zio.aws.s3.model.primitives.{TargetPrefix, TargetBucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoggingEnabled(
    targetBucket: TargetBucket,
    targetGrants: Option[Iterable[zio.aws.s3.model.TargetGrant]] = None,
    targetPrefix: TargetPrefix
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.LoggingEnabled = {
    import LoggingEnabled.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.LoggingEnabled
      .builder()
      .targetBucket(TargetBucket.unwrap(targetBucket): java.lang.String)
      .optionallyWith(
        targetGrants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGrants)
      .targetPrefix(TargetPrefix.unwrap(targetPrefix): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.LoggingEnabled.ReadOnly =
    zio.aws.s3.model.LoggingEnabled.wrap(buildAwsValue())
}
object LoggingEnabled {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.LoggingEnabled] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.LoggingEnabled =
      zio.aws.s3.model.LoggingEnabled(
        targetBucket,
        targetGrants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetPrefix
      )
    def targetBucket: TargetBucket
    def targetGrants: Option[List[zio.aws.s3.model.TargetGrant.ReadOnly]]
    def targetPrefix: TargetPrefix
    def getTargetBucket: ZIO[Any, Nothing, TargetBucket] =
      ZIO.succeed(targetBucket)
    def getTargetGrants
        : ZIO[Any, AwsError, List[zio.aws.s3.model.TargetGrant.ReadOnly]] =
      AwsError.unwrapOptionField("targetGrants", targetGrants)
    def getTargetPrefix: ZIO[Any, Nothing, TargetPrefix] =
      ZIO.succeed(targetPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.LoggingEnabled
  ) extends zio.aws.s3.model.LoggingEnabled.ReadOnly {
    override val targetBucket: TargetBucket =
      zio.aws.s3.model.primitives.TargetBucket(impl.targetBucket())
    override val targetGrants
        : Option[List[zio.aws.s3.model.TargetGrant.ReadOnly]] = scala
      .Option(impl.targetGrants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.TargetGrant.wrap(item)
        }.toList
      )
    override val targetPrefix: TargetPrefix =
      zio.aws.s3.model.primitives.TargetPrefix(impl.targetPrefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.LoggingEnabled
  ): zio.aws.s3.model.LoggingEnabled.ReadOnly = new Wrapper(impl)
}
