package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Metrics(
    status: zio.aws.s3.model.MetricsStatus,
    eventThreshold: Option[zio.aws.s3.model.ReplicationTimeValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Metrics = {
    import Metrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Metrics
      .builder()
      .status(status.unwrap)
      .optionallyWith(eventThreshold.map(value => value.buildAwsValue()))(
        _.eventThreshold
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Metrics.ReadOnly =
    zio.aws.s3.model.Metrics.wrap(buildAwsValue())
}
object Metrics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Metrics] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Metrics = zio.aws.s3.model
      .Metrics(status, eventThreshold.map(value => value.asEditable))
    def status: zio.aws.s3.model.MetricsStatus
    def eventThreshold: Option[zio.aws.s3.model.ReplicationTimeValue.ReadOnly]
    def getStatus: ZIO[Any, Nothing, zio.aws.s3.model.MetricsStatus] =
      ZIO.succeed(status)
    def getEventThreshold
        : ZIO[Any, AwsError, zio.aws.s3.model.ReplicationTimeValue.ReadOnly] =
      AwsError.unwrapOptionField("eventThreshold", eventThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Metrics
  ) extends zio.aws.s3.model.Metrics.ReadOnly {
    override val status: zio.aws.s3.model.MetricsStatus =
      zio.aws.s3.model.MetricsStatus.wrap(impl.status())
    override val eventThreshold
        : Option[zio.aws.s3.model.ReplicationTimeValue.ReadOnly] = scala
      .Option(impl.eventThreshold())
      .map(value => zio.aws.s3.model.ReplicationTimeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Metrics
  ): zio.aws.s3.model.Metrics.ReadOnly = new Wrapper(impl)
}
