package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccessPointArn, Prefix}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricsAndOperator(
    prefix: Option[Prefix] = None,
    tags: Option[Iterable[zio.aws.s3.model.Tag]] = None,
    accessPointArn: Option[AccessPointArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsAndOperator = {
    import MetricsAndOperator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsAndOperator
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        accessPointArn.map(value =>
          AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MetricsAndOperator.ReadOnly =
    zio.aws.s3.model.MetricsAndOperator.wrap(buildAwsValue())
}
object MetricsAndOperator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MetricsAndOperator =
      zio.aws.s3.model.MetricsAndOperator(
        prefix.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accessPointArn.map(value => value)
      )
    def prefix: Option[Prefix]
    def tags: Option[List[zio.aws.s3.model.Tag.ReadOnly]]
    def accessPointArn: Option[AccessPointArn]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTags: ZIO[Any, AwsError, List[zio.aws.s3.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAccessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ) extends zio.aws.s3.model.MetricsAndOperator.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tags: Option[List[zio.aws.s3.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.Tag.wrap(item)
        }.toList
      )
    override val accessPointArn: Option[AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.s3.model.primitives.AccessPointArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsAndOperator
  ): zio.aws.s3.model.MetricsAndOperator.ReadOnly = new Wrapper(impl)
}
