package zio.aws.s3.model
import zio.aws.s3.model.primitives.MetricsId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricsConfiguration(
    id: MetricsId,
    filter: Option[zio.aws.s3.model.MetricsFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsConfiguration = {
    import MetricsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsConfiguration
      .builder()
      .id(MetricsId.unwrap(id): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MetricsConfiguration.ReadOnly =
    zio.aws.s3.model.MetricsConfiguration.wrap(buildAwsValue())
}
object MetricsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MetricsConfiguration = zio.aws.s3.model
      .MetricsConfiguration(id, filter.map(value => value.asEditable))
    def id: MetricsId
    def filter: Option[zio.aws.s3.model.MetricsFilter.ReadOnly]
    def getId: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(id)
    def getFilter: ZIO[Any, AwsError, zio.aws.s3.model.MetricsFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ) extends zio.aws.s3.model.MetricsConfiguration.ReadOnly {
    override val id: MetricsId =
      zio.aws.s3.model.primitives.MetricsId(impl.id())
    override val filter: Option[zio.aws.s3.model.MetricsFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.s3.model.MetricsFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ): zio.aws.s3.model.MetricsConfiguration.ReadOnly = new Wrapper(impl)
}
