package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccessPointArn, Prefix}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MetricsFilter(
    prefix: Option[Prefix] = None,
    tag: Option[zio.aws.s3.model.Tag] = None,
    accessPointArn: Option[AccessPointArn] = None,
    and: Option[zio.aws.s3.model.MetricsAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsFilter = {
    import MetricsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsFilter
      .builder()
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(
        accessPointArn.map(value =>
          AccessPointArn.unwrap(value): java.lang.String
        )
      )(_.accessPointArn)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.MetricsFilter.ReadOnly =
    zio.aws.s3.model.MetricsFilter.wrap(buildAwsValue())
}
object MetricsFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.MetricsFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.MetricsFilter =
      zio.aws.s3.model.MetricsFilter(
        prefix.map(value => value),
        tag.map(value => value.asEditable),
        accessPointArn.map(value => value),
        and.map(value => value.asEditable)
      )
    def prefix: Option[Prefix]
    def tag: Option[zio.aws.s3.model.Tag.ReadOnly]
    def accessPointArn: Option[AccessPointArn]
    def and: Option[zio.aws.s3.model.MetricsAndOperator.ReadOnly]
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getTag: ZIO[Any, AwsError, zio.aws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tag)
    def getAccessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
    def getAnd
        : ZIO[Any, AwsError, zio.aws.s3.model.MetricsAndOperator.ReadOnly] =
      AwsError.unwrapOptionField("and", and)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ) extends zio.aws.s3.model.MetricsFilter.ReadOnly {
    override val prefix: Option[Prefix] = scala
      .Option(impl.prefix())
      .map(value => zio.aws.s3.model.primitives.Prefix(value))
    override val tag: Option[zio.aws.s3.model.Tag.ReadOnly] =
      scala.Option(impl.tag()).map(value => zio.aws.s3.model.Tag.wrap(value))
    override val accessPointArn: Option[AccessPointArn] = scala
      .Option(impl.accessPointArn())
      .map(value => zio.aws.s3.model.primitives.AccessPointArn(value))
    override val and: Option[zio.aws.s3.model.MetricsAndOperator.ReadOnly] =
      scala
        .Option(impl.and())
        .map(value => zio.aws.s3.model.MetricsAndOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ): zio.aws.s3.model.MetricsFilter.ReadOnly = new Wrapper(impl)
}
