package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{VersionCount, Days}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NoncurrentVersionTransition(
    noncurrentDays: Option[Days] = None,
    storageClass: Option[zio.aws.s3.model.TransitionStorageClass] = None,
    newerNoncurrentVersions: Option[VersionCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition = {
    import NoncurrentVersionTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
      .builder()
      .optionallyWith(noncurrentDays.map(value => Days.unwrap(value): Integer))(
        _.noncurrentDays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        newerNoncurrentVersions.map(value =>
          VersionCount.unwrap(value): Integer
        )
      )(_.newerNoncurrentVersions)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly =
    zio.aws.s3.model.NoncurrentVersionTransition.wrap(buildAwsValue())
}
object NoncurrentVersionTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NoncurrentVersionTransition =
      zio.aws.s3.model.NoncurrentVersionTransition(
        noncurrentDays.map(value => value),
        storageClass.map(value => value),
        newerNoncurrentVersions.map(value => value)
      )
    def noncurrentDays: Option[Days]
    def storageClass: Option[zio.aws.s3.model.TransitionStorageClass]
    def newerNoncurrentVersions: Option[VersionCount]
    def getNoncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDays)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.TransitionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getNewerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] = AwsError
      .unwrapOptionField("newerNoncurrentVersions", newerNoncurrentVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ) extends zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly {
    override val noncurrentDays: Option[Days] = scala
      .Option(impl.noncurrentDays())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val storageClass: Option[zio.aws.s3.model.TransitionStorageClass] =
      scala
        .Option(impl.storageClass())
        .map(value => zio.aws.s3.model.TransitionStorageClass.wrap(value))
    override val newerNoncurrentVersions: Option[VersionCount] = scala
      .Option(impl.newerNoncurrentVersions())
      .map(value => zio.aws.s3.model.primitives.VersionCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ): zio.aws.s3.model.NoncurrentVersionTransition.ReadOnly = new Wrapper(impl)
}
