package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NotificationConfigurationFilter(
    key: Option[zio.aws.s3.model.S3KeyFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter = {
    import NotificationConfigurationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
      .builder()
      .optionallyWith(key.map(value => value.buildAwsValue()))(_.key)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly =
    zio.aws.s3.model.NotificationConfigurationFilter.wrap(buildAwsValue())
}
object NotificationConfigurationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.NotificationConfigurationFilter =
      zio.aws.s3.model
        .NotificationConfigurationFilter(key.map(value => value.asEditable))
    def key: Option[zio.aws.s3.model.S3KeyFilter.ReadOnly]
    def getKey: ZIO[Any, AwsError, zio.aws.s3.model.S3KeyFilter.ReadOnly] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ) extends zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly {
    override val key: Option[zio.aws.s3.model.S3KeyFilter.ReadOnly] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.S3KeyFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ): zio.aws.s3.model.NotificationConfigurationFilter.ReadOnly = new Wrapper(
    impl
  )
}
