package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ObjectLockLegalHold(
    status: Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockLegalHold = {
    import ObjectLockLegalHold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectLockLegalHold.ReadOnly =
    zio.aws.s3.model.ObjectLockLegalHold.wrap(buildAwsValue())
}
object ObjectLockLegalHold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectLockLegalHold =
      zio.aws.s3.model.ObjectLockLegalHold(status.map(value => value))
    def status: Option[zio.aws.s3.model.ObjectLockLegalHoldStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ) extends zio.aws.s3.model.ObjectLockLegalHold.ReadOnly {
    override val status: Option[zio.aws.s3.model.ObjectLockLegalHoldStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.s3.model.ObjectLockLegalHoldStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ): zio.aws.s3.model.ObjectLockLegalHold.ReadOnly = new Wrapper(impl)
}
