package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{
  ChecksumSHA256,
  ChecksumCRC32C,
  ChecksumCRC32,
  Size,
  ChecksumSHA1,
  PartNumber
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ObjectPart(
    partNumber: Option[PartNumber] = None,
    size: Option[Size] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.ObjectPart = {
    import ObjectPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectPart
      .builder()
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(size.map(value => Size.unwrap(value): Integer))(_.size)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectPart.ReadOnly =
    zio.aws.s3.model.ObjectPart.wrap(buildAwsValue())
}
object ObjectPart {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectPart] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectPart = zio.aws.s3.model.ObjectPart(
      partNumber.map(value => value),
      size.map(value => value),
      checksumCRC32.map(value => value),
      checksumCRC32C.map(value => value),
      checksumSHA1.map(value => value),
      checksumSHA256.map(value => value)
    )
    def partNumber: Option[PartNumber]
    def size: Option[Size]
    def checksumCRC32: Option[ChecksumCRC32]
    def checksumCRC32C: Option[ChecksumCRC32C]
    def checksumSHA1: Option[ChecksumSHA1]
    def checksumSHA256: Option[ChecksumSHA256]
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getSize: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", size)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectPart
  ) extends zio.aws.s3.model.ObjectPart.ReadOnly {
    override val partNumber: Option[PartNumber] = scala
      .Option(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val size: Option[Size] = scala
      .Option(impl.size())
      .map(value => zio.aws.s3.model.primitives.Size(value))
    override val checksumCRC32: Option[ChecksumCRC32] = scala
      .Option(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Option[ChecksumCRC32C] = scala
      .Option(impl.checksumCRC32C())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Option[ChecksumSHA1] = scala
      .Option(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Option[ChecksumSHA256] = scala
      .Option(impl.checksumSHA256())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectPart
  ): zio.aws.s3.model.ObjectPart.ReadOnly = new Wrapper(impl)
}
