package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  ETag,
  IsLatest,
  LastModified,
  ObjectKey,
  ObjectVersionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ObjectVersion(
    eTag: Option[ETag] = None,
    checksumAlgorithm: Option[Iterable[zio.aws.s3.model.ChecksumAlgorithm]] =
      None,
    size: Option[Long] = None,
    storageClass: Option[zio.aws.s3.model.ObjectVersionStorageClass] = None,
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    isLatest: Option[IsLatest] = None,
    lastModified: Option[LastModified] = None,
    owner: Option[zio.aws.s3.model.Owner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectVersion = {
    import ObjectVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectVersion
      .builder()
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(
        checksumAlgorithm.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.checksumAlgorithmWithStrings)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isLatest.map(value => IsLatest.unwrap(value): java.lang.Boolean)
      )(_.isLatest)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ObjectVersion.ReadOnly =
    zio.aws.s3.model.ObjectVersion.wrap(buildAwsValue())
}
object ObjectVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ObjectVersion =
      zio.aws.s3.model.ObjectVersion(
        eTag.map(value => value),
        checksumAlgorithm.map(value => value),
        size.map(value => value),
        storageClass.map(value => value),
        key.map(value => value),
        versionId.map(value => value),
        isLatest.map(value => value),
        lastModified.map(value => value),
        owner.map(value => value.asEditable)
      )
    def eTag: Option[ETag]
    def checksumAlgorithm: Option[List[zio.aws.s3.model.ChecksumAlgorithm]]
    def size: Option[Long]
    def storageClass: Option[zio.aws.s3.model.ObjectVersionStorageClass]
    def key: Option[ObjectKey]
    def versionId: Option[ObjectVersionId]
    def isLatest: Option[IsLatest]
    def lastModified: Option[LastModified]
    def owner: Option[zio.aws.s3.model.Owner.ReadOnly]
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, List[zio.aws.s3.model.ChecksumAlgorithm]] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
    def getStorageClass
        : ZIO[Any, AwsError, zio.aws.s3.model.ObjectVersionStorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatest)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getOwner: ZIO[Any, AwsError, zio.aws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", owner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ) extends zio.aws.s3.model.ObjectVersion.ReadOnly {
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val checksumAlgorithm
        : Option[List[zio.aws.s3.model.ChecksumAlgorithm]] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.ChecksumAlgorithm.wrap(item)
        }.toList
      )
    override val size: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
    override val storageClass
        : Option[zio.aws.s3.model.ObjectVersionStorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.ObjectVersionStorageClass.wrap(value))
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val isLatest: Option[IsLatest] = scala
      .Option(impl.isLatest())
      .map(value => zio.aws.s3.model.primitives.IsLatest(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val owner: Option[zio.aws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => zio.aws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ): zio.aws.s3.model.ObjectVersion.ReadOnly = new Wrapper(impl)
}
