package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OutputSerialization(
    csv: Option[zio.aws.s3.model.CSVOutput] = None,
    json: Option[zio.aws.s3.model.JSONOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OutputSerialization = {
    import OutputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OutputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.OutputSerialization.ReadOnly =
    zio.aws.s3.model.OutputSerialization.wrap(buildAwsValue())
}
object OutputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OutputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.OutputSerialization =
      zio.aws.s3.model.OutputSerialization(
        csv.map(value => value.asEditable),
        json.map(value => value.asEditable)
      )
    def csv: Option[zio.aws.s3.model.CSVOutput.ReadOnly]
    def json: Option[zio.aws.s3.model.JSONOutput.ReadOnly]
    def getCsv: ZIO[Any, AwsError, zio.aws.s3.model.CSVOutput.ReadOnly] =
      AwsError.unwrapOptionField("csv", csv)
    def getJson: ZIO[Any, AwsError, zio.aws.s3.model.JSONOutput.ReadOnly] =
      AwsError.unwrapOptionField("json", json)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OutputSerialization
  ) extends zio.aws.s3.model.OutputSerialization.ReadOnly {
    override val csv: Option[zio.aws.s3.model.CSVOutput.ReadOnly] = scala
      .Option(impl.csv())
      .map(value => zio.aws.s3.model.CSVOutput.wrap(value))
    override val json: Option[zio.aws.s3.model.JSONOutput.ReadOnly] = scala
      .Option(impl.json())
      .map(value => zio.aws.s3.model.JSONOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OutputSerialization
  ): zio.aws.s3.model.OutputSerialization.ReadOnly = new Wrapper(impl)
}
