package zio.aws.s3.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.s3.model.primitives.{
  ETag,
  ChecksumSHA256,
  LastModified,
  ChecksumCRC32C,
  ChecksumCRC32,
  ChecksumSHA1,
  PartNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Part(
    partNumber: Option[PartNumber] = None,
    lastModified: Option[LastModified] = None,
    eTag: Option[ETag] = None,
    size: Option[Long] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Part = {
    import Part.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Part
      .builder()
      .optionallyWith(
        partNumber.map(value => PartNumber.unwrap(value): Integer)
      )(_.partNumber)
      .optionallyWith(
        lastModified.map(value => LastModified.unwrap(value): Instant)
      )(_.lastModified)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(
        checksumCRC32.map(value =>
          ChecksumCRC32.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32)
      .optionallyWith(
        checksumCRC32C.map(value =>
          ChecksumCRC32C.unwrap(value): java.lang.String
        )
      )(_.checksumCRC32C)
      .optionallyWith(
        checksumSHA1.map(value => ChecksumSHA1.unwrap(value): java.lang.String)
      )(_.checksumSHA1)
      .optionallyWith(
        checksumSHA256.map(value =>
          ChecksumSHA256.unwrap(value): java.lang.String
        )
      )(_.checksumSHA256)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.Part.ReadOnly =
    zio.aws.s3.model.Part.wrap(buildAwsValue())
}
object Part {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Part] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.Part = zio.aws.s3.model.Part(
      partNumber.map(value => value),
      lastModified.map(value => value),
      eTag.map(value => value),
      size.map(value => value),
      checksumCRC32.map(value => value),
      checksumCRC32C.map(value => value),
      checksumSHA1.map(value => value),
      checksumSHA256.map(value => value)
    )
    def partNumber: Option[PartNumber]
    def lastModified: Option[LastModified]
    def eTag: Option[ETag]
    def size: Option[Long]
    def checksumCRC32: Option[ChecksumCRC32]
    def checksumCRC32C: Option[ChecksumCRC32C]
    def checksumSHA1: Option[ChecksumSHA1]
    def checksumSHA256: Option[ChecksumSHA256]
    def getPartNumber: ZIO[Any, AwsError, PartNumber] =
      AwsError.unwrapOptionField("partNumber", partNumber)
    def getLastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
    def getChecksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32)
    def getChecksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32C)
    def getChecksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1)
    def getChecksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Part
  ) extends zio.aws.s3.model.Part.ReadOnly {
    override val partNumber: Option[PartNumber] = scala
      .Option(impl.partNumber())
      .map(value => zio.aws.s3.model.primitives.PartNumber(value))
    override val lastModified: Option[LastModified] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.s3.model.primitives.LastModified(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.s3.model.primitives.ETag(value))
    override val size: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
    override val checksumCRC32: Option[ChecksumCRC32] = scala
      .Option(impl.checksumCRC32())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32(value))
    override val checksumCRC32C: Option[ChecksumCRC32C] = scala
      .Option(impl.checksumCRC32C())
      .map(value => zio.aws.s3.model.primitives.ChecksumCRC32C(value))
    override val checksumSHA1: Option[ChecksumSHA1] = scala
      .Option(impl.checksumSHA1())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA1(value))
    override val checksumSHA256: Option[ChecksumSHA256] = scala
      .Option(impl.checksumSHA256())
      .map(value => zio.aws.s3.model.primitives.ChecksumSHA256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Part
  ): zio.aws.s3.model.Part.ReadOnly = new Wrapper(impl)
}
