package zio.aws.s3.model
import zio.aws.s3.model.primitives.IsPublic
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicyStatus(isPublic: Option[IsPublic] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.PolicyStatus = {
    import PolicyStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PolicyStatus
      .builder()
      .optionallyWith(
        isPublic.map(value => IsPublic.unwrap(value): java.lang.Boolean)
      )(_.isPublic)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PolicyStatus.ReadOnly =
    zio.aws.s3.model.PolicyStatus.wrap(buildAwsValue())
}
object PolicyStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.PolicyStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PolicyStatus =
      zio.aws.s3.model.PolicyStatus(isPublic.map(value => value))
    def isPublic: Option[IsPublic]
    def getIsPublic: ZIO[Any, AwsError, IsPublic] =
      AwsError.unwrapOptionField("isPublic", isPublic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PolicyStatus
  ) extends zio.aws.s3.model.PolicyStatus.ReadOnly {
    override val isPublic: Option[IsPublic] = scala
      .Option(impl.isPublic())
      .map(value => zio.aws.s3.model.primitives.IsPublic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PolicyStatus
  ): zio.aws.s3.model.PolicyStatus.ReadOnly = new Wrapper(impl)
}
