package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, AnalyticsId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketAnalyticsConfigurationRequest(
    bucket: BucketName,
    id: AnalyticsId,
    analyticsConfiguration: zio.aws.s3.model.AnalyticsConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest = {
    import PutBucketAnalyticsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(AnalyticsId.unwrap(id): java.lang.String)
      .analyticsConfiguration(analyticsConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketAnalyticsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest =
      zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest(
        bucket,
        id,
        analyticsConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: AnalyticsId
    def analyticsConfiguration: zio.aws.s3.model.AnalyticsConfiguration.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(id)
    def getAnalyticsConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.AnalyticsConfiguration.ReadOnly] =
      ZIO.succeed(analyticsConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: AnalyticsId =
      zio.aws.s3.model.primitives.AnalyticsId(impl.id())
    override val analyticsConfiguration
        : zio.aws.s3.model.AnalyticsConfiguration.ReadOnly =
      zio.aws.s3.model.AnalyticsConfiguration
        .wrap(impl.analyticsConfiguration())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ): zio.aws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
