package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, ContentMD5, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketEncryptionRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[zio.aws.s3.model.ChecksumAlgorithm] = None,
    serverSideEncryptionConfiguration: zio.aws.s3.model.ServerSideEncryptionConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest = {
    import PutBucketEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        contentMD5.map(value => ContentMD5.unwrap(value): java.lang.String)
      )(_.contentMD5)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .serverSideEncryptionConfiguration(
        serverSideEncryptionConfiguration.buildAwsValue()
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.PutBucketEncryptionRequest.ReadOnly =
    zio.aws.s3.model.PutBucketEncryptionRequest.wrap(buildAwsValue())
}
object PutBucketEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketEncryptionRequest =
      zio.aws.s3.model.PutBucketEncryptionRequest(
        bucket,
        contentMD5.map(value => value),
        checksumAlgorithm.map(value => value),
        serverSideEncryptionConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def contentMD5: Option[ContentMD5]
    def checksumAlgorithm: Option[zio.aws.s3.model.ChecksumAlgorithm]
    def serverSideEncryptionConfiguration
        : zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getContentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5)
    def getChecksumAlgorithm
        : ZIO[Any, AwsError, zio.aws.s3.model.ChecksumAlgorithm] =
      AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithm)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(serverSideEncryptionConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ) extends zio.aws.s3.model.PutBucketEncryptionRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val contentMD5: Option[ContentMD5] = scala
      .Option(impl.contentMD5())
      .map(value => zio.aws.s3.model.primitives.ContentMD5(value))
    override val checksumAlgorithm: Option[zio.aws.s3.model.ChecksumAlgorithm] =
      scala
        .Option(impl.checksumAlgorithm())
        .map(value => zio.aws.s3.model.ChecksumAlgorithm.wrap(value))
    override val serverSideEncryptionConfiguration
        : zio.aws.s3.model.ServerSideEncryptionConfiguration.ReadOnly =
      zio.aws.s3.model.ServerSideEncryptionConfiguration
        .wrap(impl.serverSideEncryptionConfiguration())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ): zio.aws.s3.model.PutBucketEncryptionRequest.ReadOnly = new Wrapper(impl)
}
