package zio.aws.s3.model
import zio.aws.s3.model.primitives.{AccountId, InventoryId, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutBucketInventoryConfigurationRequest(
    bucket: BucketName,
    id: InventoryId,
    inventoryConfiguration: zio.aws.s3.model.InventoryConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest = {
    import PutBucketInventoryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .id(InventoryId.unwrap(id): java.lang.String)
      .inventoryConfiguration(inventoryConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly =
    zio.aws.s3.model.PutBucketInventoryConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketInventoryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.PutBucketInventoryConfigurationRequest =
      zio.aws.s3.model.PutBucketInventoryConfigurationRequest(
        bucket,
        id,
        inventoryConfiguration.asEditable,
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def id: InventoryId
    def inventoryConfiguration: zio.aws.s3.model.InventoryConfiguration.ReadOnly
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getId: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(id)
    def getInventoryConfiguration
        : ZIO[Any, Nothing, zio.aws.s3.model.InventoryConfiguration.ReadOnly] =
      ZIO.succeed(inventoryConfiguration)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ) extends zio.aws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val id: InventoryId =
      zio.aws.s3.model.primitives.InventoryId(impl.id())
    override val inventoryConfiguration
        : zio.aws.s3.model.InventoryConfiguration.ReadOnly =
      zio.aws.s3.model.InventoryConfiguration
        .wrap(impl.inventoryConfiguration())
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ): zio.aws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
