package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReplicationTime(
    status: zio.aws.s3.model.ReplicationTimeStatus,
    time: zio.aws.s3.model.ReplicationTimeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicationTime = {
    import ReplicationTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicationTime
      .builder()
      .status(status.unwrap)
      .time(time.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3.model.ReplicationTime.ReadOnly =
    zio.aws.s3.model.ReplicationTime.wrap(buildAwsValue())
}
object ReplicationTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicationTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.ReplicationTime =
      zio.aws.s3.model.ReplicationTime(status, time.asEditable)
    def status: zio.aws.s3.model.ReplicationTimeStatus
    def time: zio.aws.s3.model.ReplicationTimeValue.ReadOnly
    def getStatus: ZIO[Any, Nothing, zio.aws.s3.model.ReplicationTimeStatus] =
      ZIO.succeed(status)
    def getTime
        : ZIO[Any, Nothing, zio.aws.s3.model.ReplicationTimeValue.ReadOnly] =
      ZIO.succeed(time)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTime
  ) extends zio.aws.s3.model.ReplicationTime.ReadOnly {
    override val status: zio.aws.s3.model.ReplicationTimeStatus =
      zio.aws.s3.model.ReplicationTimeStatus.wrap(impl.status())
    override val time: zio.aws.s3.model.ReplicationTimeValue.ReadOnly =
      zio.aws.s3.model.ReplicationTimeValue.wrap(impl.time())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicationTime
  ): zio.aws.s3.model.ReplicationTime.ReadOnly = new Wrapper(impl)
}
