package zio.aws.s3.model
import zio.aws.s3.model.primitives.EnableRequestProgress
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RequestProgress(
    enabled: Option[EnableRequestProgress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RequestProgress = {
    import RequestProgress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RequestProgress
      .builder()
      .optionallyWith(
        enabled.map(value =>
          EnableRequestProgress.unwrap(value): java.lang.Boolean
        )
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RequestProgress.ReadOnly =
    zio.aws.s3.model.RequestProgress.wrap(buildAwsValue())
}
object RequestProgress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RequestProgress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RequestProgress =
      zio.aws.s3.model.RequestProgress(enabled.map(value => value))
    def enabled: Option[EnableRequestProgress]
    def getEnabled: ZIO[Any, AwsError, EnableRequestProgress] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RequestProgress
  ) extends zio.aws.s3.model.RequestProgress.ReadOnly {
    override val enabled: Option[EnableRequestProgress] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.s3.model.primitives.EnableRequestProgress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RequestProgress
  ): zio.aws.s3.model.RequestProgress.ReadOnly = new Wrapper(impl)
}
