package zio.aws.s3.model
import java.lang.Integer
import zio.aws.s3.model.primitives.{Description, Days}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RestoreRequest(
    days: Option[Days] = None,
    glacierJobParameters: Option[zio.aws.s3.model.GlacierJobParameters] = None,
    `type`: Option[zio.aws.s3.model.RestoreRequestType] = None,
    tier: Option[zio.aws.s3.model.Tier] = None,
    description: Option[Description] = None,
    selectParameters: Option[zio.aws.s3.model.SelectParameters] = None,
    outputLocation: Option[zio.aws.s3.model.OutputLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RestoreRequest = {
    import RestoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RestoreRequest
      .builder()
      .optionallyWith(days.map(value => Days.unwrap(value): Integer))(_.days)
      .optionallyWith(glacierJobParameters.map(value => value.buildAwsValue()))(
        _.glacierJobParameters
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(selectParameters.map(value => value.buildAwsValue()))(
        _.selectParameters
      )
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.RestoreRequest.ReadOnly =
    zio.aws.s3.model.RestoreRequest.wrap(buildAwsValue())
}
object RestoreRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RestoreRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.RestoreRequest =
      zio.aws.s3.model.RestoreRequest(
        days.map(value => value),
        glacierJobParameters.map(value => value.asEditable),
        `type`.map(value => value),
        tier.map(value => value),
        description.map(value => value),
        selectParameters.map(value => value.asEditable),
        outputLocation.map(value => value.asEditable)
      )
    def days: Option[Days]
    def glacierJobParameters
        : Option[zio.aws.s3.model.GlacierJobParameters.ReadOnly]
    def `type`: Option[zio.aws.s3.model.RestoreRequestType]
    def tier: Option[zio.aws.s3.model.Tier]
    def description: Option[Description]
    def selectParameters: Option[zio.aws.s3.model.SelectParameters.ReadOnly]
    def outputLocation: Option[zio.aws.s3.model.OutputLocation.ReadOnly]
    def getDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", days)
    def getGlacierJobParameters
        : ZIO[Any, AwsError, zio.aws.s3.model.GlacierJobParameters.ReadOnly] =
      AwsError.unwrapOptionField("glacierJobParameters", glacierJobParameters)
    def getType: ZIO[Any, AwsError, zio.aws.s3.model.RestoreRequestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTier: ZIO[Any, AwsError, zio.aws.s3.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSelectParameters
        : ZIO[Any, AwsError, zio.aws.s3.model.SelectParameters.ReadOnly] =
      AwsError.unwrapOptionField("selectParameters", selectParameters)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.s3.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ) extends zio.aws.s3.model.RestoreRequest.ReadOnly {
    override val days: Option[Days] = scala
      .Option(impl.days())
      .map(value => zio.aws.s3.model.primitives.Days(value))
    override val glacierJobParameters
        : Option[zio.aws.s3.model.GlacierJobParameters.ReadOnly] = scala
      .Option(impl.glacierJobParameters())
      .map(value => zio.aws.s3.model.GlacierJobParameters.wrap(value))
    override val `type`: Option[zio.aws.s3.model.RestoreRequestType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.s3.model.RestoreRequestType.wrap(value))
    override val tier: Option[zio.aws.s3.model.Tier] =
      scala.Option(impl.tier()).map(value => zio.aws.s3.model.Tier.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.s3.model.primitives.Description(value))
    override val selectParameters
        : Option[zio.aws.s3.model.SelectParameters.ReadOnly] = scala
      .Option(impl.selectParameters())
      .map(value => zio.aws.s3.model.SelectParameters.wrap(value))
    override val outputLocation
        : Option[zio.aws.s3.model.OutputLocation.ReadOnly] = scala
      .Option(impl.outputLocation())
      .map(value => zio.aws.s3.model.OutputLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RestoreRequest
  ): zio.aws.s3.model.RestoreRequest.ReadOnly = new Wrapper(impl)
}
