package zio.aws.s3.model
import zio.aws.s3.model.primitives.{Message, Code, ObjectVersionId, ObjectKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Error(
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    code: Option[Code] = None,
    message: Option[Message] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Error = {
    import S3Error.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Error
      .builder()
      .optionallyWith(
        key.map(value => ObjectKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        versionId.map(value => ObjectVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3Error.ReadOnly =
    zio.aws.s3.model.S3Error.wrap(buildAwsValue())
}
object S3Error {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Error] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3Error = zio.aws.s3.model.S3Error(
      key.map(value => value),
      versionId.map(value => value),
      code.map(value => value),
      message.map(value => value)
    )
    def key: Option[ObjectKey]
    def versionId: Option[ObjectVersionId]
    def code: Option[Code]
    def message: Option[Message]
    def getKey: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", key)
    def getVersionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Error
  ) extends zio.aws.s3.model.S3Error.ReadOnly {
    override val key: Option[ObjectKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.s3.model.primitives.ObjectKey(value))
    override val versionId: Option[ObjectVersionId] = scala
      .Option(impl.versionId())
      .map(value => zio.aws.s3.model.primitives.ObjectVersionId(value))
    override val code: Option[Code] = scala
      .Option(impl.code())
      .map(value => zio.aws.s3.model.primitives.Code(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.s3.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Error
  ): zio.aws.s3.model.S3Error.ReadOnly = new Wrapper(impl)
}
