package zio.aws.s3.model
import zio.aws.s3.model.primitives.{LocationPrefix, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucketName: BucketName,
    prefix: LocationPrefix,
    encryption: Option[zio.aws.s3.model.Encryption] = None,
    cannedACL: Option[zio.aws.s3.model.ObjectCannedACL] = None,
    accessControlList: Option[Iterable[zio.aws.s3.model.Grant]] = None,
    tagging: Option[zio.aws.s3.model.Tagging] = None,
    userMetadata: Option[Iterable[zio.aws.s3.model.MetadataEntry]] = None,
    storageClass: Option[zio.aws.s3.model.StorageClass] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.S3Location
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .prefix(LocationPrefix.unwrap(prefix): java.lang.String)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(cannedACL.map(value => value.unwrap))(_.cannedACL)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(tagging.map(value => value.buildAwsValue()))(_.tagging)
      .optionallyWith(
        userMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userMetadata)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.S3Location.ReadOnly =
    zio.aws.s3.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.S3Location = zio.aws.s3.model.S3Location(
      bucketName,
      prefix,
      encryption.map(value => value.asEditable),
      cannedACL.map(value => value),
      accessControlList.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tagging.map(value => value.asEditable),
      userMetadata.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      storageClass.map(value => value)
    )
    def bucketName: BucketName
    def prefix: LocationPrefix
    def encryption: Option[zio.aws.s3.model.Encryption.ReadOnly]
    def cannedACL: Option[zio.aws.s3.model.ObjectCannedACL]
    def accessControlList: Option[List[zio.aws.s3.model.Grant.ReadOnly]]
    def tagging: Option[zio.aws.s3.model.Tagging.ReadOnly]
    def userMetadata: Option[List[zio.aws.s3.model.MetadataEntry.ReadOnly]]
    def storageClass: Option[zio.aws.s3.model.StorageClass]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getPrefix: ZIO[Any, Nothing, LocationPrefix] = ZIO.succeed(prefix)
    def getEncryption
        : ZIO[Any, AwsError, zio.aws.s3.model.Encryption.ReadOnly] =
      AwsError.unwrapOptionField("encryption", encryption)
    def getCannedACL: ZIO[Any, AwsError, zio.aws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("cannedACL", cannedACL)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.s3.model.Grant.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getTagging: ZIO[Any, AwsError, zio.aws.s3.model.Tagging.ReadOnly] =
      AwsError.unwrapOptionField("tagging", tagging)
    def getUserMetadata
        : ZIO[Any, AwsError, List[zio.aws.s3.model.MetadataEntry.ReadOnly]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
    def getStorageClass: ZIO[Any, AwsError, zio.aws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ) extends zio.aws.s3.model.S3Location.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucketName())
    override val prefix: LocationPrefix =
      zio.aws.s3.model.primitives.LocationPrefix(impl.prefix())
    override val encryption: Option[zio.aws.s3.model.Encryption.ReadOnly] =
      scala
        .Option(impl.encryption())
        .map(value => zio.aws.s3.model.Encryption.wrap(value))
    override val cannedACL: Option[zio.aws.s3.model.ObjectCannedACL] = scala
      .Option(impl.cannedACL())
      .map(value => zio.aws.s3.model.ObjectCannedACL.wrap(value))
    override val accessControlList
        : Option[List[zio.aws.s3.model.Grant.ReadOnly]] = scala
      .Option(impl.accessControlList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.Grant.wrap(item)
        }.toList
      )
    override val tagging: Option[zio.aws.s3.model.Tagging.ReadOnly] = scala
      .Option(impl.tagging())
      .map(value => zio.aws.s3.model.Tagging.wrap(value))
    override val userMetadata
        : Option[List[zio.aws.s3.model.MetadataEntry.ReadOnly]] = scala
      .Option(impl.userMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.MetadataEntry.wrap(item)
        }.toList
      )
    override val storageClass: Option[zio.aws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => zio.aws.s3.model.StorageClass.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.S3Location
  ): zio.aws.s3.model.S3Location.ReadOnly = new Wrapper(impl)
}
