package zio.aws.s3.model
import zio.aws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  Expression,
  ObjectKey,
  BucketName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SelectObjectContentRequest(
    bucket: BucketName,
    key: ObjectKey,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    expression: Expression,
    expressionType: zio.aws.s3.model.ExpressionType,
    requestProgress: Option[zio.aws.s3.model.RequestProgress] = None,
    inputSerialization: zio.aws.s3.model.InputSerialization,
    outputSerialization: zio.aws.s3.model.OutputSerialization,
    scanRange: Option[zio.aws.s3.model.ScanRange] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.SelectObjectContentRequest = {
    import SelectObjectContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .key(ObjectKey.unwrap(key): java.lang.String)
      .optionallyWith(
        sseCustomerAlgorithm.map(value =>
          SSECustomerAlgorithm.unwrap(value): java.lang.String
        )
      )(_.sseCustomerAlgorithm)
      .optionallyWith(
        sseCustomerKey.map(value =>
          SSECustomerKey.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKey)
      .optionallyWith(
        sseCustomerKeyMD5.map(value =>
          SSECustomerKeyMD5.unwrap(value): java.lang.String
        )
      )(_.sseCustomerKeyMD5)
      .expression(Expression.unwrap(expression): java.lang.String)
      .expressionType(expressionType.unwrap)
      .optionallyWith(requestProgress.map(value => value.buildAwsValue()))(
        _.requestProgress
      )
      .inputSerialization(inputSerialization.buildAwsValue())
      .outputSerialization(outputSerialization.buildAwsValue())
      .optionallyWith(scanRange.map(value => value.buildAwsValue()))(
        _.scanRange
      )
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.SelectObjectContentRequest.ReadOnly =
    zio.aws.s3.model.SelectObjectContentRequest.wrap(buildAwsValue())
}
object SelectObjectContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.SelectObjectContentRequest =
      zio.aws.s3.model.SelectObjectContentRequest(
        bucket,
        key,
        sseCustomerAlgorithm.map(value => value),
        sseCustomerKey.map(value => value),
        sseCustomerKeyMD5.map(value => value),
        expression,
        expressionType,
        requestProgress.map(value => value.asEditable),
        inputSerialization.asEditable,
        outputSerialization.asEditable,
        scanRange.map(value => value.asEditable),
        expectedBucketOwner.map(value => value)
      )
    def bucket: BucketName
    def key: ObjectKey
    def sseCustomerAlgorithm: Option[SSECustomerAlgorithm]
    def sseCustomerKey: Option[SSECustomerKey]
    def sseCustomerKeyMD5: Option[SSECustomerKeyMD5]
    def expression: Expression
    def expressionType: zio.aws.s3.model.ExpressionType
    def requestProgress: Option[zio.aws.s3.model.RequestProgress.ReadOnly]
    def inputSerialization: zio.aws.s3.model.InputSerialization.ReadOnly
    def outputSerialization: zio.aws.s3.model.OutputSerialization.ReadOnly
    def scanRange: Option[zio.aws.s3.model.ScanRange.ReadOnly]
    def expectedBucketOwner: Option[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(key)
    def getSseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField("sseCustomerAlgorithm", sseCustomerAlgorithm)
    def getSseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKey)
    def getSseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5)
    def getExpression: ZIO[Any, Nothing, Expression] = ZIO.succeed(expression)
    def getExpressionType: ZIO[Any, Nothing, zio.aws.s3.model.ExpressionType] =
      ZIO.succeed(expressionType)
    def getRequestProgress
        : ZIO[Any, AwsError, zio.aws.s3.model.RequestProgress.ReadOnly] =
      AwsError.unwrapOptionField("requestProgress", requestProgress)
    def getInputSerialization
        : ZIO[Any, Nothing, zio.aws.s3.model.InputSerialization.ReadOnly] =
      ZIO.succeed(inputSerialization)
    def getOutputSerialization
        : ZIO[Any, Nothing, zio.aws.s3.model.OutputSerialization.ReadOnly] =
      ZIO.succeed(outputSerialization)
    def getScanRange: ZIO[Any, AwsError, zio.aws.s3.model.ScanRange.ReadOnly] =
      AwsError.unwrapOptionField("scanRange", scanRange)
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ) extends zio.aws.s3.model.SelectObjectContentRequest.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3.model.primitives.BucketName(impl.bucket())
    override val key: ObjectKey =
      zio.aws.s3.model.primitives.ObjectKey(impl.key())
    override val sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => zio.aws.s3.model.primitives.SSECustomerAlgorithm(value))
    override val sseCustomerKey: Option[SSECustomerKey] = scala
      .Option(impl.sseCustomerKey())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKey(value))
    override val sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => zio.aws.s3.model.primitives.SSECustomerKeyMD5(value))
    override val expression: Expression =
      zio.aws.s3.model.primitives.Expression(impl.expression())
    override val expressionType: zio.aws.s3.model.ExpressionType =
      zio.aws.s3.model.ExpressionType.wrap(impl.expressionType())
    override val requestProgress
        : Option[zio.aws.s3.model.RequestProgress.ReadOnly] = scala
      .Option(impl.requestProgress())
      .map(value => zio.aws.s3.model.RequestProgress.wrap(value))
    override val inputSerialization
        : zio.aws.s3.model.InputSerialization.ReadOnly =
      zio.aws.s3.model.InputSerialization.wrap(impl.inputSerialization())
    override val outputSerialization
        : zio.aws.s3.model.OutputSerialization.ReadOnly =
      zio.aws.s3.model.OutputSerialization.wrap(impl.outputSerialization())
    override val scanRange: Option[zio.aws.s3.model.ScanRange.ReadOnly] = scala
      .Option(impl.scanRange())
      .map(value => zio.aws.s3.model.ScanRange.wrap(value))
    override val expectedBucketOwner: Option[AccountId] = scala
      .Option(impl.expectedBucketOwner())
      .map(value => zio.aws.s3.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.SelectObjectContentRequest
  ): zio.aws.s3.model.SelectObjectContentRequest.ReadOnly = new Wrapper(impl)
}
