package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait ServerSideEncryption {
  def unwrap: software.amazon.awssdk.services.s3.model.ServerSideEncryption
}
object ServerSideEncryption {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ServerSideEncryption
  ): zio.aws.s3.model.ServerSideEncryption = value match {
    case software.amazon.awssdk.services.s3.model.ServerSideEncryption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ServerSideEncryption.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.s3.model.ServerSideEncryption.AWS_KMS =>
      val r = `aws:kms`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.ServerSideEncryption {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ServerSideEncryption =
      software.amazon.awssdk.services.s3.model.ServerSideEncryption.UNKNOWN_TO_SDK_VERSION
  }
  case object AES256 extends zio.aws.s3.model.ServerSideEncryption {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ServerSideEncryption =
      software.amazon.awssdk.services.s3.model.ServerSideEncryption.AES256
  }
  case object `aws:kms` extends zio.aws.s3.model.ServerSideEncryption {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ServerSideEncryption =
      software.amazon.awssdk.services.s3.model.ServerSideEncryption.AWS_KMS
  }
}
