package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StorageClassAnalysis(
    dataExport: Option[zio.aws.s3.model.StorageClassAnalysisDataExport] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.StorageClassAnalysis = {
    import StorageClassAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.StorageClassAnalysis
      .builder()
      .optionallyWith(dataExport.map(value => value.buildAwsValue()))(
        _.dataExport
      )
      .build()
  }
  def asReadOnly: zio.aws.s3.model.StorageClassAnalysis.ReadOnly =
    zio.aws.s3.model.StorageClassAnalysis.wrap(buildAwsValue())
}
object StorageClassAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.StorageClassAnalysis = zio.aws.s3.model
      .StorageClassAnalysis(dataExport.map(value => value.asEditable))
    def dataExport
        : Option[zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly]
    def getDataExport: ZIO[
      Any,
      AwsError,
      zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly
    ] = AwsError.unwrapOptionField("dataExport", dataExport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ) extends zio.aws.s3.model.StorageClassAnalysis.ReadOnly {
    override val dataExport
        : Option[zio.aws.s3.model.StorageClassAnalysisDataExport.ReadOnly] =
      scala
        .Option(impl.dataExport())
        .map(value =>
          zio.aws.s3.model.StorageClassAnalysisDataExport.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.StorageClassAnalysis
  ): zio.aws.s3.model.StorageClassAnalysis.ReadOnly = new Wrapper(impl)
}
