package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait StorageClassAnalysisSchemaVersion {
  def unwrap: software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion
}
object StorageClassAnalysisSchemaVersion {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion
  ): zio.aws.s3.model.StorageClassAnalysisSchemaVersion = value match {
    case software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion.V_1 =>
      val r = V_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3.model.StorageClassAnalysisSchemaVersion {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion =
      software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object V_1 extends zio.aws.s3.model.StorageClassAnalysisSchemaVersion {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion =
      software.amazon.awssdk.services.s3.model.StorageClassAnalysisSchemaVersion.V_1
  }
}
