package zio.aws.s3.model
import scala.jdk.CollectionConverters.*
sealed trait Type { def unwrap: software.amazon.awssdk.services.s3.model.Type }
object Type {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.Type
  ): zio.aws.s3.model.Type = value match {
    case software.amazon.awssdk.services.s3.model.Type.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.Type.CANONICAL_USER =>
      val r = CanonicalUser
      r
    case software.amazon.awssdk.services.s3.model.Type.AMAZON_CUSTOMER_BY_EMAIL =>
      val r = AmazonCustomerByEmail
      r
    case software.amazon.awssdk.services.s3.model.Type.GROUP =>
      val r = Group
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3.model.Type {
    override def unwrap: software.amazon.awssdk.services.s3.model.Type =
      software.amazon.awssdk.services.s3.model.Type.UNKNOWN_TO_SDK_VERSION
  }
  case object CanonicalUser extends zio.aws.s3.model.Type {
    override def unwrap: software.amazon.awssdk.services.s3.model.Type =
      software.amazon.awssdk.services.s3.model.Type.CANONICAL_USER
  }
  case object AmazonCustomerByEmail extends zio.aws.s3.model.Type {
    override def unwrap: software.amazon.awssdk.services.s3.model.Type =
      software.amazon.awssdk.services.s3.model.Type.AMAZON_CUSTOMER_BY_EMAIL
  }
  case object Group extends zio.aws.s3.model.Type {
    override def unwrap: software.amazon.awssdk.services.s3.model.Type =
      software.amazon.awssdk.services.s3.model.Type.GROUP
  }
}
