package zio.aws.s3.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class WebsiteConfiguration(
    errorDocument: Option[zio.aws.s3.model.ErrorDocument] = None,
    indexDocument: Option[zio.aws.s3.model.IndexDocument] = None,
    redirectAllRequestsTo: Option[zio.aws.s3.model.RedirectAllRequestsTo] =
      None,
    routingRules: Option[Iterable[zio.aws.s3.model.RoutingRule]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.WebsiteConfiguration = {
    import WebsiteConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
      .builder()
      .optionallyWith(errorDocument.map(value => value.buildAwsValue()))(
        _.errorDocument
      )
      .optionallyWith(indexDocument.map(value => value.buildAwsValue()))(
        _.indexDocument
      )
      .optionallyWith(
        redirectAllRequestsTo.map(value => value.buildAwsValue())
      )(_.redirectAllRequestsTo)
      .optionallyWith(
        routingRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routingRules)
      .build()
  }
  def asReadOnly: zio.aws.s3.model.WebsiteConfiguration.ReadOnly =
    zio.aws.s3.model.WebsiteConfiguration.wrap(buildAwsValue())
}
object WebsiteConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3.model.WebsiteConfiguration =
      zio.aws.s3.model.WebsiteConfiguration(
        errorDocument.map(value => value.asEditable),
        indexDocument.map(value => value.asEditable),
        redirectAllRequestsTo.map(value => value.asEditable),
        routingRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errorDocument: Option[zio.aws.s3.model.ErrorDocument.ReadOnly]
    def indexDocument: Option[zio.aws.s3.model.IndexDocument.ReadOnly]
    def redirectAllRequestsTo
        : Option[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly]
    def routingRules: Option[List[zio.aws.s3.model.RoutingRule.ReadOnly]]
    def getErrorDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.ErrorDocument.ReadOnly] =
      AwsError.unwrapOptionField("errorDocument", errorDocument)
    def getIndexDocument
        : ZIO[Any, AwsError, zio.aws.s3.model.IndexDocument.ReadOnly] =
      AwsError.unwrapOptionField("indexDocument", indexDocument)
    def getRedirectAllRequestsTo
        : ZIO[Any, AwsError, zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] =
      AwsError.unwrapOptionField("redirectAllRequestsTo", redirectAllRequestsTo)
    def getRoutingRules
        : ZIO[Any, AwsError, List[zio.aws.s3.model.RoutingRule.ReadOnly]] =
      AwsError.unwrapOptionField("routingRules", routingRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ) extends zio.aws.s3.model.WebsiteConfiguration.ReadOnly {
    override val errorDocument
        : Option[zio.aws.s3.model.ErrorDocument.ReadOnly] = scala
      .Option(impl.errorDocument())
      .map(value => zio.aws.s3.model.ErrorDocument.wrap(value))
    override val indexDocument
        : Option[zio.aws.s3.model.IndexDocument.ReadOnly] = scala
      .Option(impl.indexDocument())
      .map(value => zio.aws.s3.model.IndexDocument.wrap(value))
    override val redirectAllRequestsTo
        : Option[zio.aws.s3.model.RedirectAllRequestsTo.ReadOnly] = scala
      .Option(impl.redirectAllRequestsTo())
      .map(value => zio.aws.s3.model.RedirectAllRequestsTo.wrap(value))
    override val routingRules
        : Option[List[zio.aws.s3.model.RoutingRule.ReadOnly]] = scala
      .Option(impl.routingRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.s3.model.RoutingRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.WebsiteConfiguration
  ): zio.aws.s3.model.WebsiteConfiguration.ReadOnly = new Wrapper(impl)
}
