/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.s3.model;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.services.s3.model.InventoryConfiguration;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.ZIO;
import zio.ZIO$;
import zio.aws.core.AwsError;
import zio.aws.core.AwsError$;
import zio.aws.core.internal.package$;
import zio.aws.s3.model.InventoryConfiguration$;
import zio.aws.s3.model.InventoryDestination;
import zio.aws.s3.model.InventoryDestination$;
import zio.aws.s3.model.InventoryFilter;
import zio.aws.s3.model.InventoryFilter$;
import zio.aws.s3.model.InventoryIncludedObjectVersions;
import zio.aws.s3.model.InventoryIncludedObjectVersions$;
import zio.aws.s3.model.InventoryOptionalField;
import zio.aws.s3.model.InventoryOptionalField$;
import zio.aws.s3.model.InventorySchedule;
import zio.aws.s3.model.InventorySchedule$;
import zio.aws.s3.model.package$primitives$InventoryId$;
import zio.aws.s3.model.package$primitives$IsEnabled$;
import zio.prelude.data.Optional;

public final class InventoryConfiguration
implements Product,
Serializable {
    private final InventoryDestination destination;
    private final boolean isEnabled;
    private final Optional filter;
    private final String id;
    private final InventoryIncludedObjectVersions includedObjectVersions;
    private final Optional optionalFields;
    private final InventorySchedule schedule;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(InventoryConfiguration$.class.getDeclaredField("0bitmap$1"));

    public static InventoryConfiguration apply(InventoryDestination inventoryDestination, boolean bl, Optional<InventoryFilter> optional, String string, InventoryIncludedObjectVersions inventoryIncludedObjectVersions, Optional<Iterable<InventoryOptionalField>> optional2, InventorySchedule inventorySchedule) {
        return InventoryConfiguration$.MODULE$.apply(inventoryDestination, bl, optional, string, inventoryIncludedObjectVersions, optional2, inventorySchedule);
    }

    public static InventoryConfiguration fromProduct(Product product) {
        return InventoryConfiguration$.MODULE$.fromProduct(product);
    }

    public static InventoryConfiguration unapply(InventoryConfiguration inventoryConfiguration) {
        return InventoryConfiguration$.MODULE$.unapply(inventoryConfiguration);
    }

    public static ReadOnly wrap(software.amazon.awssdk.services.s3.model.InventoryConfiguration inventoryConfiguration) {
        return InventoryConfiguration$.MODULE$.wrap(inventoryConfiguration);
    }

    public static Optional<InventoryFilter> $lessinit$greater$default$3() {
        return InventoryConfiguration$.MODULE$.$lessinit$greater$default$3();
    }

    public static Optional<Iterable<InventoryOptionalField>> $lessinit$greater$default$6() {
        return InventoryConfiguration$.MODULE$.$lessinit$greater$default$6();
    }

    public InventoryConfiguration(InventoryDestination destination, boolean isEnabled, Optional<InventoryFilter> filter, String id, InventoryIncludedObjectVersions includedObjectVersions, Optional<Iterable<InventoryOptionalField>> optionalFields, InventorySchedule schedule) {
        this.destination = destination;
        this.isEnabled = isEnabled;
        this.filter = filter;
        this.id = id;
        this.includedObjectVersions = includedObjectVersions;
        this.optionalFields = optionalFields;
        this.schedule = schedule;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof InventoryConfiguration)) return false;
        InventoryConfiguration inventoryConfiguration = (InventoryConfiguration)object;
        InventoryDestination inventoryDestination = this.destination();
        InventoryDestination inventoryDestination2 = inventoryConfiguration.destination();
        if (inventoryDestination == null) {
            if (inventoryDestination2 != null) {
                return false;
            }
        } else if (!((Object)inventoryDestination).equals(inventoryDestination2)) return false;
        if (this.isEnabled() != inventoryConfiguration.isEnabled()) return false;
        Optional<InventoryFilter> optional = this.filter();
        Optional<InventoryFilter> optional2 = inventoryConfiguration.filter();
        if (optional == null) {
            if (optional2 != null) {
                return false;
            }
        } else if (!optional.equals(optional2)) return false;
        String string = this.id();
        String string2 = inventoryConfiguration.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        InventoryIncludedObjectVersions inventoryIncludedObjectVersions = this.includedObjectVersions();
        InventoryIncludedObjectVersions inventoryIncludedObjectVersions2 = inventoryConfiguration.includedObjectVersions();
        if (inventoryIncludedObjectVersions == null) {
            if (inventoryIncludedObjectVersions2 != null) {
                return false;
            }
        } else if (!inventoryIncludedObjectVersions.equals(inventoryIncludedObjectVersions2)) return false;
        Optional<Iterable<InventoryOptionalField>> optional3 = this.optionalFields();
        Optional<Iterable<InventoryOptionalField>> optional4 = inventoryConfiguration.optionalFields();
        if (optional3 == null) {
            if (optional4 != null) {
                return false;
            }
        } else if (!optional3.equals(optional4)) return false;
        InventorySchedule inventorySchedule = this.schedule();
        InventorySchedule inventorySchedule2 = inventoryConfiguration.schedule();
        if (inventorySchedule == null) {
            if (inventorySchedule2 == null) return true;
            return false;
        } else {
            if (!((Object)inventorySchedule).equals(inventorySchedule2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof InventoryConfiguration;
    }

    public int productArity() {
        return 7;
    }

    public String productPrefix() {
        return "InventoryConfiguration";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "destination";
            }
            case 1: {
                return "isEnabled";
            }
            case 2: {
                return "filter";
            }
            case 3: {
                return "id";
            }
            case 4: {
                return "includedObjectVersions";
            }
            case 5: {
                return "optionalFields";
            }
            case 6: {
                return "schedule";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public InventoryDestination destination() {
        return this.destination;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Optional<InventoryFilter> filter() {
        return this.filter;
    }

    public String id() {
        return this.id;
    }

    public InventoryIncludedObjectVersions includedObjectVersions() {
        return this.includedObjectVersions;
    }

    public Optional<Iterable<InventoryOptionalField>> optionalFields() {
        return this.optionalFields;
    }

    public InventorySchedule schedule() {
        return this.schedule;
    }

    public software.amazon.awssdk.services.s3.model.InventoryConfiguration buildAwsValue() {
        return (software.amazon.awssdk.services.s3.model.InventoryConfiguration)((InventoryConfiguration.Builder)InventoryConfiguration$.MODULE$.zio$aws$s3$model$InventoryConfiguration$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)((InventoryConfiguration.Builder)InventoryConfiguration$.MODULE$.zio$aws$s3$model$InventoryConfiguration$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)software.amazon.awssdk.services.s3.model.InventoryConfiguration.builder().destination(this.destination().buildAwsValue()).isEnabled(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)package$primitives$IsEnabled$.MODULE$.unwrap(BoxesRunTime.boxToBoolean((boolean)this.isEnabled())))))).optionallyWith(this.filter().map((Function1 & Serializable)value -> value.buildAwsValue()), (Function1 & Serializable)_$1 -> (Function1 & Serializable)x$0 -> _$1.filter(x$0))).id((String)package$primitives$InventoryId$.MODULE$.unwrap(this.id())).includedObjectVersions(this.includedObjectVersions().unwrap())).optionallyWith(this.optionalFields().map((Function1 & Serializable)value -> CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)value.map((Function1 & Serializable)item -> item.unwrap().toString())).asJavaCollection()), (Function1 & Serializable)_$2 -> (Function1 & Serializable)x$0 -> _$2.optionalFieldsWithStrings(x$0))).schedule(this.schedule().buildAwsValue()).build();
    }

    public ReadOnly asReadOnly() {
        return InventoryConfiguration$.MODULE$.wrap(this.buildAwsValue());
    }

    public InventoryConfiguration copy(InventoryDestination destination, boolean isEnabled, Optional<InventoryFilter> filter, String id, InventoryIncludedObjectVersions includedObjectVersions, Optional<Iterable<InventoryOptionalField>> optionalFields, InventorySchedule schedule) {
        return new InventoryConfiguration(destination, isEnabled, filter, id, includedObjectVersions, optionalFields, schedule);
    }

    public InventoryDestination copy$default$1() {
        return this.destination();
    }

    public boolean copy$default$2() {
        return this.isEnabled();
    }

    public Optional<InventoryFilter> copy$default$3() {
        return this.filter();
    }

    public String copy$default$4() {
        return this.id();
    }

    public InventoryIncludedObjectVersions copy$default$5() {
        return this.includedObjectVersions();
    }

    public Optional<Iterable<InventoryOptionalField>> copy$default$6() {
        return this.optionalFields();
    }

    public InventorySchedule copy$default$7() {
        return this.schedule();
    }

    public InventoryDestination _1() {
        return this.destination();
    }

    public boolean _2() {
        return this.isEnabled();
    }

    public Optional<InventoryFilter> _3() {
        return this.filter();
    }

    public String _4() {
        return this.id();
    }

    public InventoryIncludedObjectVersions _5() {
        return this.includedObjectVersions();
    }

    public Optional<Iterable<InventoryOptionalField>> _6() {
        return this.optionalFields();
    }

    public InventorySchedule _7() {
        return this.schedule();
    }

    public static interface ReadOnly {
        public static InventoryConfiguration asEditable$(ReadOnly $this) {
            return $this.asEditable();
        }

        default public InventoryConfiguration asEditable() {
            return InventoryConfiguration$.MODULE$.apply(this.destination().asEditable(), this.isEnabled(), (Optional<InventoryFilter>)this.filter().map((Function1 & Serializable)value -> value.asEditable()), this.id(), this.includedObjectVersions(), (Optional<Iterable<InventoryOptionalField>>)this.optionalFields().map((Function1 & Serializable)value -> value), this.schedule().asEditable());
        }

        public InventoryDestination.ReadOnly destination();

        public boolean isEnabled();

        public Optional<InventoryFilter.ReadOnly> filter();

        public String id();

        public InventoryIncludedObjectVersions includedObjectVersions();

        public Optional<List<InventoryOptionalField>> optionalFields();

        public InventorySchedule.ReadOnly schedule();

        public static ZIO getDestination$(ReadOnly $this) {
            return $this.getDestination();
        }

        default public ZIO<Object, Nothing$, InventoryDestination.ReadOnly> getDestination() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.destination(), (Object)"zio.aws.s3.model.InventoryConfiguration.ReadOnly.getDestination(InventoryConfiguration.scala:65)");
        }

        public static ZIO getIsEnabled$(ReadOnly $this) {
            return $this.getIsEnabled();
        }

        default public ZIO<Object, Nothing$, Object> getIsEnabled() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> this.isEnabled(), (Object)"zio.aws.s3.model.InventoryConfiguration.ReadOnly.getIsEnabled(InventoryConfiguration.scala:66)");
        }

        public static ZIO getFilter$(ReadOnly $this) {
            return $this.getFilter();
        }

        default public ZIO<Object, AwsError, InventoryFilter.ReadOnly> getFilter() {
            return AwsError$.MODULE$.unwrapOptionField("filter", this::getFilter$$anonfun$1);
        }

        public static ZIO getId$(ReadOnly $this) {
            return $this.getId();
        }

        default public ZIO<Object, Nothing$, String> getId() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$3 -> this.id(), (Object)"zio.aws.s3.model.InventoryConfiguration.ReadOnly.getId(InventoryConfiguration.scala:70)");
        }

        public static ZIO getIncludedObjectVersions$(ReadOnly $this) {
            return $this.getIncludedObjectVersions();
        }

        default public ZIO<Object, Nothing$, InventoryIncludedObjectVersions> getIncludedObjectVersions() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$4 -> this.includedObjectVersions(), (Object)"zio.aws.s3.model.InventoryConfiguration.ReadOnly.getIncludedObjectVersions(InventoryConfiguration.scala:73)");
        }

        public static ZIO getOptionalFields$(ReadOnly $this) {
            return $this.getOptionalFields();
        }

        default public ZIO<Object, AwsError, List<InventoryOptionalField>> getOptionalFields() {
            return AwsError$.MODULE$.unwrapOptionField("optionalFields", this::getOptionalFields$$anonfun$1);
        }

        public static ZIO getSchedule$(ReadOnly $this) {
            return $this.getSchedule();
        }

        default public ZIO<Object, Nothing$, InventorySchedule.ReadOnly> getSchedule() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$5 -> this.schedule(), (Object)"zio.aws.s3.model.InventoryConfiguration.ReadOnly.getSchedule(InventoryConfiguration.scala:79)");
        }

        private Optional getFilter$$anonfun$1() {
            return this.filter();
        }

        private Optional getOptionalFields$$anonfun$1() {
            return this.optionalFields();
        }
    }

    public static final class Wrapper
    implements ReadOnly {
        private final InventoryDestination.ReadOnly destination;
        private final boolean isEnabled;
        private final Optional filter;
        private final String id;
        private final InventoryIncludedObjectVersions includedObjectVersions;
        private final Optional optionalFields;
        private final InventorySchedule.ReadOnly schedule;

        public Wrapper(software.amazon.awssdk.services.s3.model.InventoryConfiguration impl) {
            this.destination = InventoryDestination$.MODULE$.wrap(impl.destination());
            package$primitives$IsEnabled$ Newtype_this = package$primitives$IsEnabled$.MODULE$;
            this.isEnabled = Predef$.MODULE$.Boolean2boolean(impl.isEnabled());
            this.filter = package$.MODULE$.optionalFromNullable((Object)impl.filter()).map((Function1 & Serializable)value -> InventoryFilter$.MODULE$.wrap((software.amazon.awssdk.services.s3.model.InventoryFilter)value));
            package$primitives$InventoryId$ Newtype_this2 = package$primitives$InventoryId$.MODULE$;
            this.id = impl.id();
            this.includedObjectVersions = InventoryIncludedObjectVersions$.MODULE$.wrap(impl.includedObjectVersions());
            this.optionalFields = package$.MODULE$.optionalFromNullable((Object)impl.optionalFields()).map((Function1 & Serializable)value -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().map((Function1 & Serializable)item -> InventoryOptionalField$.MODULE$.wrap((software.amazon.awssdk.services.s3.model.InventoryOptionalField)item))).toList());
            this.schedule = InventorySchedule$.MODULE$.wrap(impl.schedule());
        }

        @Override
        public InventoryDestination.ReadOnly destination() {
            return this.destination;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public Optional<InventoryFilter.ReadOnly> filter() {
            return this.filter;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public InventoryIncludedObjectVersions includedObjectVersions() {
            return this.includedObjectVersions;
        }

        @Override
        public Optional<List<InventoryOptionalField>> optionalFields() {
            return this.optionalFields;
        }

        @Override
        public InventorySchedule.ReadOnly schedule() {
            return this.schedule;
        }
    }
}

