package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountLevel(
    activityMetrics: Optional[zio.aws.s3control.model.ActivityMetrics] =
      Optional.Absent,
    bucketLevel: zio.aws.s3control.model.BucketLevel,
    advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics
    ] = Optional.Absent,
    advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics
    ] = Optional.Absent,
    detailedStatusCodesMetrics: Optional[
      zio.aws.s3control.model.DetailedStatusCodesMetrics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AccountLevel = {
    import AccountLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AccountLevel
      .builder()
      .optionallyWith(activityMetrics.map(value => value.buildAwsValue()))(
        _.activityMetrics
      )
      .bucketLevel(bucketLevel.buildAwsValue())
      .optionallyWith(
        advancedCostOptimizationMetrics.map(value => value.buildAwsValue())
      )(_.advancedCostOptimizationMetrics)
      .optionallyWith(
        advancedDataProtectionMetrics.map(value => value.buildAwsValue())
      )(_.advancedDataProtectionMetrics)
      .optionallyWith(
        detailedStatusCodesMetrics.map(value => value.buildAwsValue())
      )(_.detailedStatusCodesMetrics)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AccountLevel.ReadOnly =
    zio.aws.s3control.model.AccountLevel.wrap(buildAwsValue())
}
object AccountLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AccountLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AccountLevel =
      zio.aws.s3control.model.AccountLevel(
        activityMetrics.map(value => value.asEditable),
        bucketLevel.asEditable,
        advancedCostOptimizationMetrics.map(value => value.asEditable),
        advancedDataProtectionMetrics.map(value => value.asEditable),
        detailedStatusCodesMetrics.map(value => value.asEditable)
      )
    def activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly]
    def bucketLevel: zio.aws.s3control.model.BucketLevel.ReadOnly
    def advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ]
    def advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ]
    def detailedStatusCodesMetrics
        : Optional[zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly]
    def getActivityMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      AwsError.unwrapOptionField("activityMetrics", activityMetrics)
    def getBucketLevel
        : ZIO[Any, Nothing, zio.aws.s3control.model.BucketLevel.ReadOnly] =
      ZIO.succeed(bucketLevel)
    def getAdvancedCostOptimizationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedCostOptimizationMetrics",
      advancedCostOptimizationMetrics
    )
    def getAdvancedDataProtectionMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedDataProtectionMetrics",
      advancedDataProtectionMetrics
    )
    def getDetailedStatusCodesMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "detailedStatusCodesMetrics",
      detailedStatusCodesMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AccountLevel
  ) extends zio.aws.s3control.model.AccountLevel.ReadOnly {
    override val activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityMetrics())
        .map(value => zio.aws.s3control.model.ActivityMetrics.wrap(value))
    override val bucketLevel: zio.aws.s3control.model.BucketLevel.ReadOnly =
      zio.aws.s3control.model.BucketLevel.wrap(impl.bucketLevel())
    override val advancedCostOptimizationMetrics: Optional[
      zio.aws.s3control.model.AdvancedCostOptimizationMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedCostOptimizationMetrics())
      .map(value =>
        zio.aws.s3control.model.AdvancedCostOptimizationMetrics.wrap(value)
      )
    override val advancedDataProtectionMetrics: Optional[
      zio.aws.s3control.model.AdvancedDataProtectionMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedDataProtectionMetrics())
      .map(value =>
        zio.aws.s3control.model.AdvancedDataProtectionMetrics.wrap(value)
      )
    override val detailedStatusCodesMetrics: Optional[
      zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatusCodesMetrics())
      .map(value =>
        zio.aws.s3control.model.DetailedStatusCodesMetrics.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AccountLevel
  ): zio.aws.s3control.model.AccountLevel.ReadOnly = new Wrapper(impl)
}
