package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait AsyncOperationName {
  def unwrap: software.amazon.awssdk.services.s3control.model.AsyncOperationName
}
object AsyncOperationName {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.AsyncOperationName
  ): zio.aws.s3control.model.AsyncOperationName = value match {
    case software.amazon.awssdk.services.s3control.model.AsyncOperationName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.AsyncOperationName.CREATE_MULTI_REGION_ACCESS_POINT =>
      val r = CreateMultiRegionAccessPoint
      r
    case software.amazon.awssdk.services.s3control.model.AsyncOperationName.DELETE_MULTI_REGION_ACCESS_POINT =>
      val r = DeleteMultiRegionAccessPoint
      r
    case software.amazon.awssdk.services.s3control.model.AsyncOperationName.PUT_MULTI_REGION_ACCESS_POINT_POLICY =>
      val r = PutMultiRegionAccessPointPolicy
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.AsyncOperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.AsyncOperationName =
      software.amazon.awssdk.services.s3control.model.AsyncOperationName.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateMultiRegionAccessPoint
      extends zio.aws.s3control.model.AsyncOperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.AsyncOperationName =
      software.amazon.awssdk.services.s3control.model.AsyncOperationName.CREATE_MULTI_REGION_ACCESS_POINT
  }
  case object DeleteMultiRegionAccessPoint
      extends zio.aws.s3control.model.AsyncOperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.AsyncOperationName =
      software.amazon.awssdk.services.s3control.model.AsyncOperationName.DELETE_MULTI_REGION_ACCESS_POINT
  }
  case object PutMultiRegionAccessPointPolicy
      extends zio.aws.s3control.model.AsyncOperationName {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.AsyncOperationName =
      software.amazon.awssdk.services.s3control.model.AsyncOperationName.PUT_MULTI_REGION_ACCESS_POINT_POLICY
  }
}
