package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AsyncRequestParameters(
    createMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput
    ] = Optional.Absent,
    deleteMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput
    ] = Optional.Absent,
    putMultiRegionAccessPointPolicyRequest: Optional[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.AsyncRequestParameters = {
    import AsyncRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
      .builder()
      .optionallyWith(
        createMultiRegionAccessPointRequest.map(value => value.buildAwsValue())
      )(_.createMultiRegionAccessPointRequest)
      .optionallyWith(
        deleteMultiRegionAccessPointRequest.map(value => value.buildAwsValue())
      )(_.deleteMultiRegionAccessPointRequest)
      .optionallyWith(
        putMultiRegionAccessPointPolicyRequest.map(value =>
          value.buildAwsValue()
        )
      )(_.putMultiRegionAccessPointPolicyRequest)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.AsyncRequestParameters.ReadOnly =
    zio.aws.s3control.model.AsyncRequestParameters.wrap(buildAwsValue())
}
object AsyncRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.AsyncRequestParameters =
      zio.aws.s3control.model.AsyncRequestParameters(
        createMultiRegionAccessPointRequest.map(value => value.asEditable),
        deleteMultiRegionAccessPointRequest.map(value => value.asEditable),
        putMultiRegionAccessPointPolicyRequest.map(value => value.asEditable)
      )
    def createMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ]
    def deleteMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ]
    def putMultiRegionAccessPointPolicyRequest: Optional[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ]
    def getCreateMultiRegionAccessPointRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createMultiRegionAccessPointRequest",
      createMultiRegionAccessPointRequest
    )
    def getDeleteMultiRegionAccessPointRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deleteMultiRegionAccessPointRequest",
      deleteMultiRegionAccessPointRequest
    )
    def getPutMultiRegionAccessPointPolicyRequest: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "putMultiRegionAccessPointPolicyRequest",
      putMultiRegionAccessPointPolicyRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ) extends zio.aws.s3control.model.AsyncRequestParameters.ReadOnly {
    override val createMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.CreateMultiRegionAccessPointInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createMultiRegionAccessPointRequest())
      .map(value =>
        zio.aws.s3control.model.CreateMultiRegionAccessPointInput.wrap(value)
      )
    override val deleteMultiRegionAccessPointRequest: Optional[
      zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteMultiRegionAccessPointRequest())
      .map(value =>
        zio.aws.s3control.model.DeleteMultiRegionAccessPointInput.wrap(value)
      )
    override val putMultiRegionAccessPointPolicyRequest: Optional[
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.putMultiRegionAccessPointPolicyRequest())
      .map(value =>
        zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.AsyncRequestParameters
  ): zio.aws.s3control.model.AsyncRequestParameters.ReadOnly = new Wrapper(impl)
}
