package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait BucketVersioningStatus {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.BucketVersioningStatus
}
object BucketVersioningStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.BucketVersioningStatus
  ): zio.aws.s3control.model.BucketVersioningStatus = value match {
    case software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3control.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.ENABLED
  }
  case object Suspended extends zio.aws.s3control.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3control.model.BucketVersioningStatus.SUSPENDED
  }
}
