package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class DeleteBucketReplicationRequest(
    accountId: AccountId,
    bucket: BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest = {
    import DeleteBucketReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteBucketReplicationRequest.ReadOnly =
    zio.aws.s3control.model.DeleteBucketReplicationRequest.wrap(buildAwsValue())
}
object DeleteBucketReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DeleteBucketReplicationRequest =
      zio.aws.s3control.model.DeleteBucketReplicationRequest(accountId, bucket)
    def accountId: AccountId
    def bucket: BucketName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest
  ) extends zio.aws.s3control.model.DeleteBucketReplicationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketReplicationRequest
  ): zio.aws.s3control.model.DeleteBucketReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
