package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters._
final case class DetailedStatusCodesMetrics(
    isEnabled: Optional[IsEnabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics = {
    import DetailedStatusCodesMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics
      .builder()
      .optionallyWith(
        isEnabled.map(value => IsEnabled.unwrap(value): java.lang.Boolean)
      )(_.isEnabled)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly =
    zio.aws.s3control.model.DetailedStatusCodesMetrics.wrap(buildAwsValue())
}
object DetailedStatusCodesMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.DetailedStatusCodesMetrics =
      zio.aws.s3control.model
        .DetailedStatusCodesMetrics(isEnabled.map(value => value))
    def isEnabled: Optional[IsEnabled]
    def getIsEnabled: ZIO[Any, AwsError, IsEnabled] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics
  ) extends zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly {
    override val isEnabled: Optional[IsEnabled] = zio.aws.core.internal
      .optionalFromNullable(impl.isEnabled())
      .map(value => zio.aws.s3control.model.primitives.IsEnabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DetailedStatusCodesMetrics
  ): zio.aws.s3control.model.DetailedStatusCodesMetrics.ReadOnly = new Wrapper(
    impl
  )
}
